/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.IOButton;
import com.github.almostreliable.energymeter.client.gui.IntervalBox;
import com.github.almostreliable.energymeter.client.gui.SettingButton;
import com.github.almostreliable.energymeter.client.gui.ThresholdBox;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MeterScreen
extends AbstractContainerScreen<MeterContainer> {
    private static final ResourceLocation TEXTURE = TextUtils.getRL("textures/gui/meter.png");
    private static final int TEXTURE_WIDTH = 199;
    private static final int TEXTURE_HEIGHT = 129;
    private static final GuiUtils.Tooltip TOOLTIP = MeterScreen.setupTooltip();
    private final Collection<AbstractWidget> toRender = new ArrayList<AbstractWidget>();
    private IntervalBox intervalBox;
    private ThresholdBox thresholdBox;

    public MeterScreen(MeterContainer container, Inventory inventory, Component name) {
        super((AbstractContainerMenu)container, inventory, name);
        this.f_97726_ = 199;
        this.f_97727_ = 129;
    }

    private static GuiUtils.Tooltip setupTooltip() {
        return GuiUtils.Tooltip.builder().addHeader("side_config").addBlankLine().addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_side", ChatFormatting.GREEN).m_7220_((Component)TextUtils.colorize(": ", ChatFormatting.GREEN)).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.BLOCK_SIDE, TypeEnums.BLOCK_SIDE.FRONT.toString().toLowerCase(), ChatFormatting.WHITE))).addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_mode", ChatFormatting.GREEN).m_7220_((Component)TextUtils.colorize(": ", ChatFormatting.GREEN)).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.IO_SETTING, "screen", ChatFormatting.WHITE)));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.intervalBox = new IntervalBox(this, this.f_96547_, this.f_97735_ + 18, this.f_97736_ + this.f_97727_ + 5, 42, 8);
        this.addRenderable((AbstractWidget)this.intervalBox);
        this.thresholdBox = new ThresholdBox(this, this.f_96547_, this.f_97735_ + 81, this.f_97736_ + this.f_97727_ + 5, 42, 8);
        this.addRenderable((AbstractWidget)this.thresholdBox);
        this.addRenderables(IOButton.create(this, TypeEnums.BLOCK_SIDE.values()));
        this.addRenderable((AbstractWidget)new SettingButton(this, 136, 64, TypeEnums.SETTING.NUMBER));
        this.addRenderable((AbstractWidget)new SettingButton(this, 136, 86, TypeEnums.SETTING.MODE));
        this.addRenderable((AbstractWidget)new SettingButton(this, 136, 108, TypeEnums.SETTING.ACCURACY));
    }

    public void m_6305_(PoseStack stack, int mX, int mY, float partial) {
        this.m_7333_(stack);
        super.m_6305_(stack, mX, mY, partial);
        this.m_7025_(stack, mX, mY);
    }

    protected void m_7025_(PoseStack stack, int mX, int mY) {
        if (this.isWithinRegion(mX, mY, 159, 16, 23, 16)) {
            this.m_96597_(stack, TOOLTIP.resolve(), mX, mY);
            return;
        }
        for (AbstractWidget widget : this.toRender) {
            if (!widget.m_198029_() || !widget.f_93624_) continue;
            widget.m_7428_(stack, mX, mY);
        }
        super.m_7025_(stack, mX, mY);
    }

    protected void m_7027_(PoseStack stack, int pX, int pY) {
        GuiUtils.renderText(stack, 11, 9, 1.3f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "meter"), 0xF0F0F0);
        GuiUtils.renderText(stack, 11, 26, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "transfer_rate") + ":", 0xAEAEAE);
        Tuple<String, String> formattedFlow = TextUtils.formatEnergy(((MeterContainer)this.f_97732_).getEntity().getTransferRate(), ((MeterContainer)this.f_97732_).getEntity().getNumberMode() == TypeEnums.NUMBER_MODE.LONG);
        GuiUtils.renderText(stack, 16, 37, 1.0f, String.format("%s %s/t", formattedFlow.m_14418_(), formattedFlow.m_14419_()), 65442);
        GuiUtils.renderText(stack, 11, 50, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "status") + ":", 0xAEAEAE);
        GuiUtils.renderText(stack, 16, 61, 1.0f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.STATUS, ((MeterContainer)this.f_97732_).getEntity().getStatus().toString().toLowerCase()), this.getStatusColor());
        GuiUtils.renderText(stack, 11, 74, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "mode") + ":", 0xAEAEAE);
        GuiUtils.renderText(stack, 16, 85, 1.0f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.MODE, ((MeterContainer)this.f_97732_).getEntity().getMode().toString().toLowerCase()), this.getModeColor());
        GuiUtils.renderText(stack, 11, 98, 1.1f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, "accuracy") + ":", 0xAEAEAE);
        GuiUtils.renderText(stack, 16, 109, 1.0f, TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.ACCURACY, ((MeterContainer)this.f_97732_).getEntity().getAccuracy().toString().toLowerCase()), this.getAccuracyColor());
    }

    protected void m_7286_(PoseStack stack, float partial, int mX, int mY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        MeterScreen.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
    }

    private void addRenderable(AbstractWidget widget) {
        this.m_142416_((GuiEventListener)widget);
        this.toRender.add(widget);
    }

    private void addRenderables(Iterable<? extends AbstractWidget> widgets) {
        for (AbstractWidget abstractWidget : widgets) {
            this.m_142416_((GuiEventListener)abstractWidget);
            this.toRender.add(abstractWidget);
        }
    }

    private boolean isWithinRegion(int mX, int mY, int pX, int width, int pY, int height) {
        return mX >= this.f_97735_ + pX && mX <= this.f_97735_ + pX + width && mY >= this.f_97736_ + pY && mY <= this.f_97736_ + pY + height;
    }

    IntervalBox getIntervalBox() {
        return this.intervalBox;
    }

    ThresholdBox getThresholdBox() {
        return this.thresholdBox;
    }

    private int getStatusColor() {
        TypeEnums.STATUS status = ((MeterContainer)this.f_97732_).getEntity().getStatus();
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case TypeEnums.STATUS.DISCONNECTED -> 14286889;
            case TypeEnums.STATUS.CONNECTED -> 16768512;
            case TypeEnums.STATUS.TRANSFERRING -> 65328;
            case TypeEnums.STATUS.CONSUMING -> 0xFF00F0;
        };
    }

    private int getModeColor() {
        return ((MeterContainer)this.f_97732_).getEntity().getMode() == TypeEnums.MODE.CONSUMER ? 12976383 : 40929;
    }

    private int getAccuracyColor() {
        return ((MeterContainer)this.f_97732_).getEntity().getAccuracy() == TypeEnums.ACCURACY.EXACT ? 0xFF6600 : 0xFF0066;
    }
}

