/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.network.packets.AccuracyUpdatePacket;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

abstract class GenericTextBox
extends EditBox {
    protected final MeterScreen screen;
    private final Font font;
    private final TypeEnums.TEXT_BOX identifier;

    GenericTextBox(MeterScreen screen, Font font, int pX, int pY, int width, int height, TypeEnums.TEXT_BOX identifier) {
        super(font, pX, pY, width, height, (Component)Component.m_237119_());
        this.screen = screen;
        this.font = font;
        this.identifier = identifier;
        this.m_94182_(false);
        this.m_94202_(0xF0F0F0);
        this.m_94153_(text -> StringUtils.isNumeric((CharSequence)text) || text.isEmpty());
        this.m_94199_(7);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == InputConstants.m_84851_((String)"key.keyboard.enter").m_84873_()) {
            this.m_94178_(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean clicked = super.m_6375_(pMouseX, pMouseY, pButton);
        if (clicked && Screen.m_96638_()) {
            this.reset();
            if (this.identifier == TypeEnums.TEXT_BOX.INTERVAL) {
                this.screen.getThresholdBox().reset();
            }
        }
        return clicked;
    }

    public void m_94178_(boolean focused) {
        if (this.m_93696_() && !focused) {
            this.screen.getIntervalBox().validateTextBox();
            this.screen.getThresholdBox().validateTextBox();
        }
        super.m_94178_(focused);
    }

    public void m_6303_(PoseStack stack, int mX, int mY, float partial) {
        if (((MeterContainer)this.screen.m_6262_()).getEntity().getAccuracy() == TypeEnums.ACCURACY.EXACT) {
            return;
        }
        String label = TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.LABEL, this.identifier.toString().toLowerCase()) + ":";
        int labelWidth = this.font.m_92895_(label);
        this.f_93622_ = mX >= this.f_93620_ - 4 - labelWidth && mY >= this.f_93621_ - 3 && mX < this.f_93620_ + this.f_93618_ + 3 && mY < this.f_93621_ + this.f_93619_ + 3;
        GuiUtils.renderText(stack, this.f_93620_ - 4 - labelWidth, this.f_93621_, 1.0f, label, 0xF0F0F0);
        GenericTextBox.m_93172_((PoseStack)stack, (int)(this.f_93620_ - 3), (int)(this.f_93621_ - 3), (int)(this.f_93620_ + this.f_93618_ + 3), (int)(this.f_93621_ + this.f_93619_ + 3), (int)-65434);
        GenericTextBox.m_93172_((PoseStack)stack, (int)(this.f_93620_ - 2), (int)(this.f_93621_ - 2), (int)(this.f_93620_ + this.f_93618_ + 2), (int)(this.f_93621_ + this.f_93619_ + 2), (int)-15263977);
        super.m_6303_(stack, mX, mY, partial);
    }

    protected void changeTextBoxValue(int value, boolean sync) {
        this.m_94144_(String.valueOf(Math.max(value, 5)));
        if (sync) {
            PacketHandler.CHANNEL.sendToServer((Object)new AccuracyUpdatePacket(this.identifier, Math.max(value, 5)));
        }
    }

    void reset() {
        this.changeTextBoxValue(5, true);
    }

    void validateTextBox() {
        int value;
        int oldValue = this.getOldValue();
        try {
            value = Integer.parseInt(this.m_94155_());
        }
        catch (NumberFormatException e) {
            this.changeTextBoxValue(oldValue, false);
            return;
        }
        if (value != oldValue) {
            this.changeTextBoxValue(value, true);
        }
    }

    public boolean m_198029_() {
        return this.f_93622_;
    }

    public void m_7428_(PoseStack stack, int mX, int mY) {
        if (((MeterContainer)this.screen.m_6262_()).getEntity().getAccuracy() == TypeEnums.ACCURACY.EXACT) {
            return;
        }
        this.screen.m_96597_(stack, this.getTooltip().resolve(), mX, mY);
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
    }

    protected abstract GuiUtils.Tooltip getTooltip();

    protected abstract int getOldValue();
}

