/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client;

import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.state.properties.Property;

public class MeterRenderer
implements BlockEntityRenderer<MeterEntity> {
    private static final float[] ANGLE = new float[]{0.0f, 0.0f, 0.0f, 180.0f, 90.0f, -90.0f};
    private static final float PIXEL_SIZE = 0.01875f;
    private static final float OFFSET = 0.001f;
    private static final int MAX_DISTANCE = 30;
    private static final float HALF = 0.5f;
    private final Minecraft mc = Minecraft.m_91087_();
    private final Font font;

    public MeterRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    private static Vector3f getFacingVector(Direction facing) {
        if (facing.ordinal() < 2) {
            return new Vector3f(0.5f, facing == Direction.UP ? 1.001f : -0.001f, 0.5f);
        }
        if (facing.ordinal() < 4) {
            return new Vector3f(0.5f, 0.5f, facing == Direction.NORTH ? -0.001f : 1.001f);
        }
        return new Vector3f(facing == Direction.WEST ? -0.001f : 1.001f, 0.5f, 0.5f);
    }

    public void render(MeterEntity entity, float partial, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        if (entity.m_58899_().m_123331_((Vec3i)this.mc.f_91074_.m_20183_()) > Math.pow(30.0, 2.0)) {
            return;
        }
        Direction facing = (Direction)entity.m_58900_().m_61143_((Property)MeterBlock.FACING);
        Direction bottom = (Direction)entity.m_58900_().m_61143_((Property)MeterBlock.BOTTOM);
        Vector3f vector = MeterRenderer.getFacingVector(facing);
        stack.m_85836_();
        stack.m_85837_((double)vector.m_122239_(), (double)vector.m_122260_(), (double)vector.m_122269_());
        if (facing == bottom) {
            stack.m_85845_(new Quaternion(0.0f, ANGLE[facing.ordinal()], 180.0f, true));
        } else {
            stack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
            stack.m_85845_(Vector3f.f_122222_.m_122240_(facing == Direction.UP ? 90.0f : -90.0f));
            stack.m_85845_(Vector3f.f_122226_.m_122240_(facing == Direction.DOWN ? 180.0f - ANGLE[bottom.ordinal()] : ANGLE[bottom.ordinal()]));
        }
        stack.m_85841_(0.01875f, 0.01875f, 0.0f);
        Tuple<String, String> text = TextUtils.formatEnergy(entity.getTransferRate(), false);
        String flowRate = (String)text.m_14418_();
        String unit = (String)text.m_14419_() + "/t";
        float f = (float)this.font.m_92895_(flowRate) / -2.0f;
        Objects.requireNonNull(this.font);
        this.font.m_92883_(stack, flowRate, f, (float)(-9) - 0.001f, ChatFormatting.WHITE.m_126665_().intValue());
        this.font.m_92883_(stack, unit, (float)this.font.m_92895_(unit) / -2.0f, 0.001f, ChatFormatting.WHITE.m_126665_().intValue());
        stack.m_85849_();
    }
}

