/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.structure;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.world.feature.SourceFeature;
import sirttas.elementalcraft.world.feature.structure.ECStructureTypes;

public class SourceAltarStructure
extends Structure {
    public static final String NAME = "source_altar";
    public static final Codec<SourceAltarStructure> CODEC = SourceAltarStructure.m_226607_(SourceAltarStructure::new);

    public SourceAltarStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, ElementType elementType) {
        WorldgenRandom random = context.f_226626_();
        builder.m_142679_((StructurePiece)new Piece(context.f_226625_(), SourceAltarStructure.getRoll((RandomSource)random), new BlockPos(context.f_226628_().m_45604_(), 90, context.f_226628_().m_45605_()), elementType));
    }

    private static ResourceLocation getRoll(RandomSource random) {
        int roll = random.m_188503_(20);
        if (roll == 0) {
            return ElementalCraft.createRL("altar/chapel");
        }
        if (roll <= 3) {
            return ElementalCraft.createRL("altar/medium");
        }
        return ElementalCraft.createRL("altar/small");
    }

    @Nonnull
    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        return SourceAltarStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, b -> this.generatePieces((StructurePiecesBuilder)b, context, ElementType.random((RandomSource)context.f_226626_())));
    }

    @Nonnull
    public StructureType<?> m_213658_() {
        return (StructureType)ECStructureTypes.SOURCE_ALTAR.get();
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ElementType elementType;

        public Piece(StructureTemplateManager manager, ResourceLocation templateName, BlockPos pos, ElementType elementType) {
            super((StructurePieceType)ECStructureTypes.SOURCE_ALTAR_PIECE_TYPE.get(), 0, manager, templateName, templateName.toString(), Piece.makeSettings(templateName), pos);
            this.elementType = elementType;
        }

        public Piece(StructureTemplateManager manager, CompoundTag tag) {
            super((StructurePieceType)ECStructureTypes.SOURCE_ALTAR_PIECE_TYPE.get(), tag, manager, Piece::makeSettings);
            this.elementType = ElementType.byName(tag.m_128461_("ElementType"));
        }

        private static StructurePlaceSettings makeSettings(ResourceLocation id) {
            return new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74385_(new BlockPos(1, 0, 1)).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_183620_(@Nonnull StructurePieceSerializationContext context, @Nonnull CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("ElementType", this.elementType.m_7912_());
        }

        public void m_213694_(WorldGenLevel level, @Nonnull StructureManager structureManager, @Nonnull ChunkGenerator chunkGenerator, @Nonnull RandomSource random, @Nonnull BoundingBox boundingBox, @Nonnull ChunkPos chunkPos, @Nonnull BlockPos pos) {
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_()) - 1, this.f_73658_.m_123343_());
            super.m_213694_(level, structureManager, chunkGenerator, random, boundingBox, chunkPos, pos);
        }

        protected void m_213704_(String name, @Nonnull BlockPos pos, @Nonnull ServerLevelAccessor level, @Nonnull RandomSource rand, @Nonnull BoundingBox sbb) {
            if (name.endsWith("chest")) {
                this.m_226762_(level, sbb, rand, pos, ElementalCraft.createRL("chests/altar/" + this.getChestType(name) + "_" + this.elementType.m_7912_()), null);
                level.m_6289_(pos, Blocks.f_50087_);
            } else if (name.startsWith("source")) {
                SourceFeature.placeSource(level, pos, this.elementType, this.getSourceLuck(name));
            }
        }

        private String getChestType(String name) {
            String[] split = name.split("_");
            return split.length > 1 ? split[0] : "small";
        }

        private int getSourceLuck(String name) {
            String[] split = name.split("_");
            try {
                return split.length > 1 ? Integer.parseInt(split[1]) : 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

