/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.spell.Spell;

public class DashSpell
extends Spell {
    public static final String NAME = "dash";

    public DashSpell(ResourceKey<Spell> key) {
        super(key);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        LivingEntity livingEntity;
        float range = this.getRange(caster);
        if (caster.m_20159_()) {
            return InteractionResult.PASS;
        }
        if (caster instanceof LivingEntity && this.isFlying(livingEntity = (LivingEntity)caster)) {
            this.effect(caster, livingEntity.m_217043_().m_216339_(10, 20) + (int)Math.ceil(range), instance -> {
                if (this.isFlying(livingEntity)) {
                    Vec3 lookAngle = livingEntity.m_20154_();
                    Vec3 movement = livingEntity.m_20184_();
                    livingEntity.m_20256_(movement.m_82520_(lookAngle.f_82479_ * 0.1 + (lookAngle.f_82479_ * 1.5 - movement.f_82479_) * 0.5, lookAngle.f_82480_ * 0.1 + (lookAngle.f_82480_ * 1.5 - movement.f_82480_) * 0.5, lookAngle.f_82481_ * 0.1 + (lookAngle.f_82481_ * 1.5 - movement.f_82481_) * 0.5));
                } else {
                    instance.stop();
                }
            });
        } else {
            caster.m_20256_(caster.m_20184_().m_82549_(caster.m_20154_().m_82541_().m_82490_((double)range)));
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isFlying(LivingEntity livingEntity) {
        FlyingAnimal flyingAnimal;
        return livingEntity.m_21255_() || livingEntity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)livingEntity).m_29443_();
    }
}

