/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.nbt.NBTHelper;
import sirttas.elementalcraft.pureore.PureOreManager;
import sirttas.elementalcraft.recipe.instrument.io.IPurifierRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class PureOre {
    private static final String MINECRAFT = "minecraft";
    private static final String DEEPSLATE = "deepslate";
    private static final Comparator<ResourceLocation> MINECRAFT_NAMESPACE_COMPARATOR = (name1, name2) -> {
        if (MINECRAFT.equals(name1.m_135827_()) && !MINECRAFT.equals(name2.m_135827_())) {
            return -1;
        }
        if (!MINECRAFT.equals(name1.m_135827_()) && MINECRAFT.equals(name2.m_135827_())) {
            return 1;
        }
        return 0;
    };
    private static final Comparator<ResourceLocation> DEEPSLATE_COMPARATOR = (name1, name2) -> {
        if (name1.m_135815_().contains(DEEPSLATE) && !name2.m_135815_().contains(DEEPSLATE)) {
            return 1;
        }
        if (!name1.m_135815_().contains(DEEPSLATE) && name2.m_135815_().contains(DEEPSLATE)) {
            return -1;
        }
        return 0;
    };
    private static final Comparator<Item> DESCRIPTION_COMPARATOR = Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0), MINECRAFT_NAMESPACE_COMPARATOR.thenComparing(DEEPSLATE_COMPARATOR).thenComparing(ResourceLocation::compareTo));
    private final ResourceLocation id;
    private final Set<Item> ores;
    private final Map<RecipeType<?>, net.minecraft.world.item.crafting.Recipe<?>> recipes;
    private ItemStack resultForColor;
    private Component description;
    private final int elementConsumption;
    private final int inputSize;
    private final int outputSize;
    private final double luckRatio;

    public PureOre(ResourceLocation id, int elementConsumption, int inputSize, int outputSize, double luckRatio) {
        this.id = id;
        this.ores = new HashSet<Item>();
        this.recipes = new HashMap();
        this.resultForColor = ItemStack.f_41583_;
        this.elementConsumption = elementConsumption;
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.luckRatio = luckRatio;
    }

    public Component getDescription() {
        if (this.description == null) {
            this.description = this.ores.stream().sorted(DESCRIPTION_COMPARATOR).map(Item::m_41466_).findFirst().orElse((Component)Component.m_237113_((String)"ERROR no name"));
        }
        return this.description;
    }

    public Ingredient getIngredient() {
        return Ingredient.m_43921_(this.getOres().stream().map(i -> {
            ItemStack stack = new ItemStack((ItemLike)i);
            stack.m_41764_(this.inputSize);
            return stack;
        }));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Set<Item> getOres() {
        return this.ores;
    }

    public boolean isProcessable() {
        return !this.ores.isEmpty() && !this.recipes.isEmpty();
    }

    public <C extends Container, T extends net.minecraft.world.item.crafting.Recipe<C>> T getRecipe(RecipeType<T> recipeType) {
        return (T)this.recipes.get(recipeType);
    }

    public <C extends Container, T extends net.minecraft.world.item.crafting.Recipe<C>> void addRecipe(T recipe) {
        RecipeType recipeType = recipe.m_6671_();
        this.recipes.put(recipe.m_6671_(), recipe);
        if (this.resultForColor.m_41619_()) {
            this.resultForColor = PureOreManager.getInjectors().stream().filter(injector -> injector.getRecipeType().equals(recipeType)).map(injector -> injector.getRecipeOutput(recipe)).filter(stack -> !stack.m_41619_()).findAny().orElse(recipe.m_8043_());
        }
    }

    public void addTag(TagKey<Item> tag) {
        this.addTag(ECTags.Items.getTag(tag));
    }

    public void addTag(HolderSet.Named<Item> tag) {
        tag.m_203614_().map(Holder::m_203334_).forEach(this.ores::add);
    }

    public boolean contains(Item item) {
        return this.ores.contains(item);
    }

    public IPurifierRecipe getRecipe() {
        return new Recipe();
    }

    public ItemStack getResultForColor() {
        return this.resultForColor;
    }

    public ItemStack createPureOre() {
        ItemStack stack = new ItemStack((ItemLike)ECItems.PURE_ORE.get());
        NBTHelper.getOrCreateECTag(stack).m_128359_("ore", this.id.toString());
        return stack;
    }

    private class Recipe
    implements IPurifierRecipe {
        private Recipe() {
        }

        @Override
        public int getElementAmount() {
            return PureOre.this.elementConsumption;
        }

        @Nonnull
        public NonNullList<Ingredient> m_7527_() {
            return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{PureOre.this.getIngredient()});
        }

        @Nonnull
        public ItemStack m_8043_() {
            ItemStack result = PureOre.this.createPureOre();
            result.m_41764_(PureOre.this.outputSize);
            return result;
        }

        @Nonnull
        public ResourceLocation m_6423_() {
            ResourceLocation resourceLocation = PureOre.this.getId();
            return ElementalCraft.createRL(resourceLocation.m_135827_() + "_" + resourceLocation.m_135815_() + "_to_pure_ore");
        }

        @Override
        public int getInputSize() {
            return PureOre.this.inputSize;
        }

        @Override
        public double getLuckRatio() {
            return PureOre.this.luckRatio;
        }
    }
}

