/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pipe;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;

public class PipeUpgradeItem
extends ECItem
implements IPipeInteractingItem {
    private final Supplier<PipeUpgradeType<?>> supplier;
    private PipeUpgradeType<?> pipeUpgradeType;

    public PipeUpgradeItem(Supplier<PipeUpgradeType<?>> supplier, Item.Properties properties) {
        super(properties);
        this.supplier = supplier;
    }

    public PipeUpgradeType<?> getPipeUpgradeType() {
        if (this.pipeUpgradeType == null) {
            this.pipeUpgradeType = this.supplier.get();
        }
        return this.pipeUpgradeType;
    }

    @Override
    @Nonnull
    public InteractionResult useOnPipe(@Nonnull ElementPipeBlockEntity pipe, @Nonnull UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Direction face = context.m_43719_();
        Player player = context.m_43723_();
        if (pipe.getUpgrade(face) != null) {
            return InteractionResult.FAIL;
        }
        Object upgrade = this.getPipeUpgradeType().create(pipe, face);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            ((PipeUpgrade)((Object)upgrade)).load(tag.m_128469_("pipe_upgrade_tag"));
        }
        if (((PipeUpgrade)((Object)upgrade)).canPlace(pipe.getConnection(face))) {
            pipe.setUpgrade(face, (PipeUpgrade)((Object)upgrade));
            if (player != null && !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nonnull
    public String m_5524_() {
        return this.pipeUpgradeType.getDescriptionId();
    }
}

