/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait;

import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraits;

public class SourceTraitHelper {
    private SourceTraitHelper() {
    }

    @Nonnull
    public static Map<ResourceKey<SourceTrait>, ISourceTraitValue> loadTraits(@Nullable CompoundTag tag) {
        SortedMap<ResourceKey<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();
        SourceTraitHelper.loadTraits(tag, traits);
        return traits;
    }

    public static void loadTraits(@Nullable CompoundTag tag, @Nonnull Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits) {
        traits.clear();
        if (tag != null) {
            for (String name : tag.m_128431_()) {
                ISourceTraitValue value;
                ResourceKey<SourceTrait> key = SourceTraits.key(name);
                SourceTrait trait = (SourceTrait)ElementalCraftApi.SOURCE_TRAIT_MANAGER.get(new ResourceLocation(name));
                if (trait == null || (value = trait.load(tag.m_128423_(name))) == null) continue;
                traits.put(key, value);
            }
        }
    }

    @Nonnull
    public static CompoundTag saveTraits(@Nonnull Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits) {
        CompoundTag traitTag = new CompoundTag();
        traits.forEach((key, value) -> {
            Tag tag;
            SourceTrait trait = (SourceTrait)ElementalCraftApi.SOURCE_TRAIT_MANAGER.get(key);
            if (trait != null && (tag = trait.save((ISourceTraitValue)value)) != null) {
                traitTag.m_128365_(trait.getId().toString(), tag);
            }
        });
        return traitTag;
    }

    public static Map<ResourceKey<SourceTrait>, ISourceTraitValue> breed(@Nonnull RandomSource random, float luck, boolean natural, Map<ResourceKey<SourceTrait>, ISourceTraitValue> map1, Map<ResourceKey<SourceTrait>, ISourceTraitValue> map2) {
        SortedMap<ResourceKey<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();
        for (Map.Entry entry : ElementalCraftApi.SOURCE_TRAIT_MANAGER.getData().entrySet()) {
            ISourceTraitValue value;
            ResourceKey<SourceTrait> key = SourceTraits.key((ResourceLocation)entry.getKey());
            if (natural && key.equals(SourceTraits.ARTIFICIAL) || (value = ((SourceTrait)entry.getValue()).breed(random, luck, map1.get(key), map2.get(key))) == null) continue;
            traits.put(key, value);
        }
        return traits;
    }
}

