/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.valve;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.IPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.valve.ElementValvePipeUpgrade;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class ElementValvePipeUpgradeRenderer
implements IPipeUpgradeRenderer<ElementValvePipeUpgrade> {
    public static final ResourceLocation OPEN_LOCATION = ElementalCraft.createRL("elementalcraft/pipe_upgrade/element_valve_open");
    public static final ResourceLocation CLOSE_LOCATION = ElementalCraft.createRL("elementalcraft/pipe_upgrade/element_valve_close");
    private BakedModel openModel;
    private BakedModel closeModel;

    @Override
    public void render(ElementValvePipeUpgrade upgrade, ElementPipeBlockEntity pipe, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (this.openModel == null || this.closeModel == null) {
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            this.openModel = modelManager.getModel(OPEN_LOCATION);
            this.closeModel = modelManager.getModel(CLOSE_LOCATION);
        }
        if (upgrade.isOpen()) {
            ECRendererHelper.renderModel(this.openModel, poseStack, buffer, pipe, light, overlay);
            ElementValvePipeUpgradeRenderer.renderParticles(upgrade, pipe);
        } else {
            ECRendererHelper.renderModel(this.closeModel, poseStack, buffer, pipe, light, overlay);
        }
    }

    private static void renderParticles(ElementValvePipeUpgrade upgrade, ElementPipeBlockEntity pipe) {
        Level level = pipe.m_58904_();
        if (level == null) {
            return;
        }
        RandomSource random = level.f_46441_;
        if (random.m_188501_() >= 0.01f) {
            return;
        }
        Direction direction = upgrade.getDirection();
        BlockPos pos = pipe.m_58899_();
        float f = -0.28125f;
        double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.2 - (double)(f * (float)direction.m_122429_());
        double y = (double)pos.m_123342_() + 0.5 + (random.m_188500_() - 0.5) * 0.2 - (double)(f * (float)direction.m_122430_());
        double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.2 - (double)(f * (float)direction.m_122431_());
        level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
    }
}

