/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerContainer;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.elemental.ShardItem;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;

public class CrystallizerBlockEntity
extends AbstractInstrumentBlockEntity<CrystallizerBlockEntity, CrystallizationRecipe> {
    private static final AbstractECCraftingBlockEntity.Config<CrystallizerBlockEntity, CrystallizationRecipe> CONFIG = new AbstractECCraftingBlockEntity.Config((Supplier<BlockEntityType<?>>)ECBlockEntityTypes.CRYSTALLIZER, (Supplier<RecipeType<CrystallizationRecipe>>)ECRecipeTypes.CRYSTALLIZATION, (Supplier<Integer>)ECConfig.COMMON.crystallizerTransferSpeed, (Supplier<Integer>)ECConfig.COMMON.crystallizerMaxRunes);
    private final InstrumentContainer inventory = new CrystallizerContainer(this);

    public CrystallizerBlockEntity(BlockPos pos, BlockState state) {
        super(CONFIG, pos, state);
        this.lockable = true;
        this.particleOffset = new Vec3(0.0, 0.2, 0.0);
    }

    public int getItemCount() {
        return this.inventory.getItemCount();
    }

    @Override
    public void assemble() {
        double luck = (double)this.getRuneHandler().getBonus(Rune.BonusType.LUCK) * (Double)ECConfig.COMMON.crystallizerLuckRatio.get();
        for (int i = 2; i < this.inventory.m_6643_(); ++i) {
            Item item;
            ItemStack stack = this.inventory.m_8020_(i);
            if (!this.isValidShard(stack) || !((item = stack.m_41720_()) instanceof ShardItem)) continue;
            ShardItem shardItem = (ShardItem)item;
            luck += (double)shardItem.getElementAmount();
        }
        ItemStack gem = this.inventory.m_8020_(0);
        this.m_6211_();
        this.inventory.m_6836_(0, ((CrystallizationRecipe)this.recipe).assemble(gem, this, (float)luck));
    }

    public boolean isValidShard(ItemStack stack) {
        return this.recipe != null && ((CrystallizationRecipe)this.recipe).isValidShard(stack);
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }
}

