/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easy_villagers.corelib.block.IItemBlock;
import de.maxhenkel.easy_villagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easy_villagers.corelib.client.CustomRendererBlockItem;
import de.maxhenkel.easy_villagers.corelib.client.ItemRenderer;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.ItemTileEntityCache;
import de.maxhenkel.easyvillagers.ModItemGroups;
import de.maxhenkel.easyvillagers.blocks.FarmerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.BreederContainer;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import de.maxhenkel.easyvillagers.items.render.BreederItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BreederBlock
extends VillagerBlockBase
implements EntityBlock,
IItemBlock {
    public BreederBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.5f).m_60918_(SoundType.f_56743_).m_60955_());
    }

    @Override
    public Item toItem() {
        return new CustomRendererBlockItem(this, new Item.Properties().m_41491_(ModItemGroups.TAB_EASY_VILLAGERS)){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public ItemRenderer createItemRenderer() {
                return new BreederItemRenderer();
            }
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
        EasyVillagerEntity villager2;
        super.m_5871_(stack, blockGetter, components, tooltipFlag);
        BreederTileentity trader = ItemTileEntityCache.getTileEntity(stack, () -> new BreederTileentity(BlockPos.f_121853_, ((TraderBlock)ModBlocks.TRADER.get()).m_49966_()));
        EasyVillagerEntity villager1 = trader.getVillagerEntity1();
        if (villager1 != null) {
            components.add(villager1.getAdvancedName());
        }
        if ((villager2 = trader.getVillagerEntity2()) != null) {
            components.add(villager2.getAdvancedName());
        }
    }

    public InteractionResult m_6227_(final BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof BreederTileentity)) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        final BreederTileentity breeder = (BreederTileentity)tileEntity;
        if (!breeder.hasVillager1() && heldItem.m_41720_() instanceof VillagerItem) {
            breeder.setVillager1(heldItem.m_41777_());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12509_);
            return InteractionResult.SUCCESS;
        }
        if (!breeder.hasVillager2() && heldItem.m_41720_() instanceof VillagerItem) {
            breeder.setVillager2(heldItem.m_41777_());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12509_);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && breeder.hasVillager2()) {
            ItemStack stack = breeder.removeVillager2();
            if (heldItem.m_41619_()) {
                player.m_21008_(handIn, stack);
            } else if (!player.m_150109_().m_36054_(stack)) {
                Direction direction = (Direction)state.m_61143_((Property)FarmerBlock.FACING);
                Containers.m_18992_((Level)worldIn, (double)((double)(direction.m_122429_() + pos.m_123341_()) + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)(direction.m_122431_() + pos.m_123343_()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12504_);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && breeder.hasVillager1()) {
            ItemStack stack = breeder.removeVillager1();
            if (heldItem.m_41619_()) {
                player.m_21008_(handIn, stack);
            } else if (!player.m_150109_().m_36054_(stack)) {
                Direction direction = (Direction)state.m_61143_((Property)FarmerBlock.FACING);
                Containers.m_18992_((Level)worldIn, (double)((double)(direction.m_122429_() + pos.m_123341_()) + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)(direction.m_122431_() + pos.m_123343_()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12504_);
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)state.m_60734_().m_7705_());
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                return new BreederContainer(id, playerInventory, breeder.getFoodInventory(), breeder.getOutputInventory());
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BreederTileentity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

