/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.message;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import sirttas.dpanvil.data.network.message.MessageHandler;

public class MessageHelper {
    public static final PacketDistributor<Void> ALL_REMOTE = new PacketDistributor(MessageHelper::playerListAllRemote, NetworkDirection.PLAY_TO_CLIENT);

    private MessageHelper() {
    }

    public static <T> void sendToPlayer(ServerPlayer serverPlayer, T message) {
        MessageHandler.CHANNEL.sendTo(message, serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <T> void sendToRemotePlayer(ServerPlayer serverPlayer, T message) {
        if (MessageHelper.isRemotePlayer((Player)serverPlayer)) {
            MessageHelper.sendToPlayer(serverPlayer, message);
        }
    }

    public static <T> void sendToAllPlayers(T message) {
        MessageHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <T> void sendToAllRemotePlayers(T message) {
        MessageHandler.CHANNEL.send(ALL_REMOTE.noArg(), message);
    }

    private static Consumer<Packet<?>> playerListAllRemote(PacketDistributor<Void> distributor, Supplier<Void> voidSupplier) {
        return p -> ((MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).m_6846_().m_11314_().stream().filter(MessageHelper::isRemotePlayer).forEach(player -> player.f_8906_.m_9829_(p));
    }

    private static boolean isRemotePlayer(Player player) {
        MinecraftServer server = player.m_20194_();
        if (server != null) {
            return !server.m_7779_(player.m_36316_());
        }
        return true;
    }
}

