/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import java.util.Map;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.deepresonance.modules.radiation.manager.QuadTree;
import mcjty.deepresonance.modules.radiation.util.RadiationShieldRegistry;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        Level world = event.getPlayer().f_19853_;
        if (world.f_46443_) {
            return;
        }
        float blocker = (float)RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalPos, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getPos().m_123341_();
        int y = event.getPos().m_123342_();
        int z = event.getPos().m_123343_();
        for (Map.Entry<GlobalPos, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalPos gc = entry.getKey();
            BlockPos c = gc.m_122646_();
            if (!((float)Math.abs(c.m_123341_() - x) < radius) || !((float)Math.abs(c.m_123342_() - y) < radius) || !((float)Math.abs(c.m_123343_() - z) < radius)) continue;
            Logging.logDebug((String)("Removed blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.m_123341_(), c.m_123342_(), c.m_123343_());
            radiationTree.addBlocker(x, y, z, 1.0f);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        float blocker = (float)RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        Level world = event.getEntity().f_19853_;
        if (world.m_5776_()) {
            return;
        }
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalPos, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getBlockSnapshot().getPos().m_123341_();
        int y = event.getBlockSnapshot().getPos().m_123342_();
        int z = event.getBlockSnapshot().getPos().m_123343_();
        for (Map.Entry<GlobalPos, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalPos gc = entry.getKey();
            BlockPos c = gc.m_122646_();
            if (!((float)Math.abs(c.m_123341_() - x) < radius) || !((float)Math.abs(c.m_123342_() - y) < radius) || !((float)Math.abs(c.m_123343_() - z) < radius)) continue;
            Logging.logDebug((String)("Add blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.m_123341_(), c.m_123342_(), c.m_123343_());
            radiationTree.addBlocker(x, y, z, blocker);
        }
    }
}

