/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.container;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.container.AbstractDankMenu;
import tfar.dankstorage.container.DockMenu;
import tfar.dankstorage.init.ModMenuTypes;
import tfar.dankstorage.inventory.LockedSlot;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.DankInventory;

public class DankMenu
extends AbstractDankMenu {
    public ItemStack bag;

    public DankMenu(MenuType<?> type, int windowId, Inventory inv, DankInventory dankInventory) {
        super(type, windowId, inv, dankInventory);
        Player player = inv.f_35978_;
        this.bag = player.m_21205_().m_41720_() instanceof DankItem ? player.m_21205_() : player.m_21206_();
        this.addDankSlots();
        this.addPlayerSlots(inv, inv.f_35977_);
    }

    @Override
    protected DataSlot getServerPickupData() {
        return new DataSlot(){

            public int m_6501_() {
                return Utils.getPickupMode(DankMenu.this.bag).ordinal();
            }

            public void m_6422_(int pValue) {
                Utils.setPickupMode(DankMenu.this.bag, PickupMode.PICKUP_MODES[pValue]);
            }
        };
    }

    public static DankMenu t1(int id, Inventory inv) {
        return DankMenu.t1s(id, inv, DockMenu.createDummy(DankStats.one));
    }

    public static DankMenu t2(int id, Inventory inv) {
        return DankMenu.t2s(id, inv, DockMenu.createDummy(DankStats.two));
    }

    public static DankMenu t3(int id, Inventory inv) {
        return DankMenu.t3s(id, inv, DockMenu.createDummy(DankStats.three));
    }

    public static DankMenu t4(int id, Inventory inv) {
        return DankMenu.t4s(id, inv, DockMenu.createDummy(DankStats.four));
    }

    public static DankMenu t5(int id, Inventory inv) {
        return DankMenu.t5s(id, inv, DockMenu.createDummy(DankStats.five));
    }

    public static DankMenu t6(int id, Inventory inv) {
        return DankMenu.t6s(id, inv, DockMenu.createDummy(DankStats.six));
    }

    public static DankMenu t7(int id, Inventory inv) {
        return DankMenu.t7s(id, inv, DockMenu.createDummy(DankStats.seven));
    }

    public static DankMenu t1s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_1_container, id, inv, dankInventory);
    }

    public static DankMenu t2s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_2_container, id, inv, dankInventory);
    }

    public static DankMenu t3s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_3_container, id, inv, dankInventory);
    }

    public static DankMenu t4s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_4_container, id, inv, dankInventory);
    }

    public static DankMenu t5s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_5_container, id, inv, dankInventory);
    }

    public static DankMenu t6s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_6_container, id, inv, dankInventory);
    }

    public static DankMenu t7s(int id, Inventory inv, DankInventory dankInventory) {
        return new DankMenu(ModMenuTypes.portable_dank_7_container, id, inv, dankInventory);
    }

    @Override
    protected void addPlayerSlots(Inventory playerinventory) {
    }

    @Override
    public void setFrequency(int freq) {
        Utils.getOrCreateSettings(this.bag).m_128405_("dankstorage:id", freq);
    }

    protected void addPlayerSlots(Inventory playerinventory, int locked) {
        int row;
        int yStart = 32 + 18 * this.rows;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + yStart;
                this.m_38897_(new Slot((Container)playerinventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = yStart + 58;
            if (row != locked) {
                this.m_38897_(new Slot((Container)playerinventory, row, x, y));
                continue;
            }
            this.m_38897_(new LockedSlot((Container)playerinventory, row, x, y));
        }
    }
}

