/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;

@GameTestGroup(path="contraptions")
public class TestContraptions {
    @GameTest(template="arrow_dispenser", timeoutTicks=200)
    public static void arrowDispenser(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 3, 1);
        helper.m_177421_(lever);
        BlockPos pos1 = new BlockPos(0, 5, 0);
        BlockPos pos2 = new BlockPos(4, 5, 4);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(7);
            List arrows = helper.getEntitiesBetween(EntityType.f_20548_, pos1, pos2);
            if (arrows.size() != 4) {
                helper.m_177284_("Expected 4 arrows");
            }
            helper.powerLever(lever);
            BlockPos dispenser = new BlockPos(2, 5, 2);
            helper.m_177242_(dispenser, Items.f_42412_);
        });
    }

    @GameTest(template="crop_farming", timeoutTicks=200)
    public static void cropFarming(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(4, 3, 1);
        helper.m_177421_(lever);
        BlockPos output = new BlockPos(1, 3, 12);
        helper.m_177361_(() -> helper.assertAnyContained(output, Items.f_42405_, Items.f_42620_, Items.f_42619_));
    }

    @GameTest(template="mounted_item_extract", timeoutTicks=400)
    public static void mountedItemExtract(CreateGameTestHelper helper) {
        BlockPos barrel = new BlockPos(1, 3, 2);
        Object2LongMap<Item> content = helper.getItemContent(barrel);
        BlockPos lever = new BlockPos(1, 5, 1);
        helper.m_177421_(lever);
        BlockPos outputPos = new BlockPos(4, 2, 1);
        helper.m_177361_(() -> {
            helper.assertContentPresent(content, outputPos);
            helper.powerLever(lever);
            helper.m_177440_(barrel);
        });
    }

    @GameTest(template="mounted_fluid_drain", timeoutTicks=200)
    public static void mountedFluidDrain(CreateGameTestHelper helper) {
        BlockPos tank = new BlockPos(1, 3, 2);
        FluidStack fluid = helper.getTankContents(tank);
        if (fluid.isEmpty()) {
            helper.m_177284_("Tank empty");
        }
        BlockPos lever = new BlockPos(1, 5, 1);
        helper.m_177421_(lever);
        BlockPos output = new BlockPos(4, 2, 1);
        helper.m_177361_(() -> {
            helper.assertFluidPresent(fluid, output);
            helper.powerLever(lever);
            helper.assertTankEmpty(tank);
        });
    }

    @GameTest(template="ploughing")
    public static void ploughing(CreateGameTestHelper helper) {
        BlockPos dirt = new BlockPos(4, 2, 1);
        BlockPos lever = new BlockPos(3, 3, 2);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.m_177208_(Blocks.f_50093_, dirt));
    }

    @GameTest(template="redstone_contacts")
    public static void redstoneContacts(CreateGameTestHelper helper) {
        BlockPos end = new BlockPos(5, 10, 1);
        BlockPos lever = new BlockPos(1, 3, 2);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.m_177208_(Blocks.f_50090_, end));
    }
}

