/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.transport;

import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.fan.FanProcessing;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class TransportedItemStack
implements Comparable<TransportedItemStack> {
    private static Random R = new Random();
    public ItemStack stack;
    public float beltPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public Direction insertedFrom;
    public boolean locked;
    public boolean lockedExternally;
    public float prevBeltPosition;
    public float prevSideOffset;
    public FanProcessing.Type processedBy;
    public int processingTime;

    public TransportedItemStack(ItemStack stack) {
        this.stack = stack;
        boolean centered = BeltHelper.isItemUpright(stack);
        this.angle = centered ? 180 : R.nextInt(360);
        this.sideOffset = this.prevSideOffset = this.getTargetSideOffset();
        this.insertedFrom = Direction.UP;
    }

    public float getTargetSideOffset() {
        return (float)(this.angle - 180) / 1080.0f;
    }

    @Override
    public int compareTo(TransportedItemStack o) {
        return this.beltPosition < o.beltPosition ? 1 : (this.beltPosition > o.beltPosition ? -1 : 0);
    }

    public TransportedItemStack getSimilar() {
        TransportedItemStack copy = new TransportedItemStack(this.stack.m_41777_());
        copy.beltPosition = this.beltPosition;
        copy.insertedAt = this.insertedAt;
        copy.insertedFrom = this.insertedFrom;
        copy.prevBeltPosition = this.prevBeltPosition;
        copy.prevSideOffset = this.prevSideOffset;
        copy.processedBy = this.processedBy;
        copy.processingTime = this.processingTime;
        return copy;
    }

    public TransportedItemStack copy() {
        TransportedItemStack copy = this.getSimilar();
        copy.angle = this.angle;
        copy.sideOffset = this.sideOffset;
        return copy;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Item", (Tag)this.stack.serializeNBT());
        nbt.m_128350_("Pos", this.beltPosition);
        nbt.m_128350_("PrevPos", this.prevBeltPosition);
        nbt.m_128350_("Offset", this.sideOffset);
        nbt.m_128350_("PrevOffset", this.prevSideOffset);
        nbt.m_128405_("InSegment", this.insertedAt);
        nbt.m_128405_("Angle", this.angle);
        nbt.m_128405_("InDirection", this.insertedFrom.m_122411_());
        if (this.locked) {
            nbt.m_128379_("Locked", this.locked);
        }
        if (this.lockedExternally) {
            nbt.m_128379_("LockedExternally", this.lockedExternally);
        }
        return nbt;
    }

    public static TransportedItemStack read(CompoundTag nbt) {
        TransportedItemStack stack = new TransportedItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item")));
        stack.beltPosition = nbt.m_128457_("Pos");
        stack.prevBeltPosition = nbt.m_128457_("PrevPos");
        stack.sideOffset = nbt.m_128457_("Offset");
        stack.prevSideOffset = nbt.m_128457_("PrevOffset");
        stack.insertedAt = nbt.m_128451_("InSegment");
        stack.angle = nbt.m_128451_("Angle");
        stack.insertedFrom = Direction.m_122376_((int)nbt.m_128451_("InDirection"));
        stack.locked = nbt.m_128471_("Locked");
        stack.lockedExternally = nbt.m_128471_("LockedExternally");
        return stack;
    }
}

