/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.registry;

import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.woodcutter.WoodCutterMod;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.item.WoodcutterItem;

public class ModBlocks {
    public static final Set<Block> WOODCUTTERS = new HashSet<Block>();
    public static final Set<Item> WOODCUTTER_ITEMS = new HashSet<Item>();
    private static final Random RANDOM = new Random();
    private static ItemStack RANDOM_STACK = ItemStack.f_41583_;

    static void onRegisterBlocks(RegisterEvent event) {
        for (VanillaWoodVariant vanillaWoodVariant : VanillaWoodVariant.values()) {
            ModBlocks.registerWoodcutter(event, vanillaWoodVariant.m_7912_());
        }
        if (SupportMods.BIOMESOPLENTY.isLoaded()) {
            for (Enum enum_ : BOPWoodVariant.values()) {
                ModBlocks.registerWoodcutter(event, ((BOPWoodVariant)enum_).m_7912_());
            }
        }
        if (SupportMods.TWILIGHT_FOREST.isLoaded()) {
            for (Enum enum_ : TFWoodVariant.values()) {
                if (enum_ == TFWoodVariant.MANGROVE) continue;
                ModBlocks.registerWoodcutter(event, ((TFWoodVariant)enum_).m_7912_());
            }
        }
        if (SupportMods.TROPICRAFT.isLoaded()) {
            ModBlocks.registerWoodcutter(event, SupportMods.TROPICRAFT.m_7912_() + "_" + TropicraftVariant.PALM.m_7912_());
            ModBlocks.registerWoodcutter(event, SupportMods.TROPICRAFT.m_7912_() + "_" + TropicraftVariant.MAHOGANY.m_7912_());
        }
        if (SupportMods.BYG.isLoaded()) {
            if (SupportMods.EXTENSION_BYG.isLoaded()) {
                for (Enum enum_ : BYGWoodVariant.values()) {
                    ModBlocks.registerWoodcutter(event, SupportMods.BYG.m_7912_() + "_" + ((BYGWoodVariant)enum_).m_7912_());
                }
            } else {
                WoodCutterMod.LOGGER.info("missing extension for \"Oh Biome You'll Go\" recipes");
            }
        }
    }

    static void onRegisterBlockItems(RegisterEvent event) {
        WOODCUTTERS.forEach(woodcutterBlock -> {
            WoodcutterItem woodcutter = new WoodcutterItem((Block)woodcutterBlock);
            WOODCUTTER_ITEMS.add((Item)woodcutter);
            event.register(ForgeRegistries.Keys.ITEMS, Helper.getRegistryRL(woodcutterBlock), () -> ModBlocks.lambda$onRegisterBlockItems$0((Item)woodcutter));
        });
    }

    private static void registerWoodcutter(RegisterEvent event, String name) {
        WoodcutterBlock woodcutter = new WoodcutterBlock();
        WOODCUTTERS.add((Block)woodcutter);
        event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation("corail_woodcutter", name + "_woodcutter"), () -> ModBlocks.lambda$registerWoodcutter$2((Block)woodcutter));
    }

    public static ItemStack createRandomStack() {
        if (RANDOM_STACK.m_41619_()) {
            RANDOM_STACK = new ItemStack((ItemLike)WOODCUTTERS.stream().skip(RANDOM.nextInt(WOODCUTTERS.size())).findFirst().orElse(Blocks.f_50679_));
        }
        return RANDOM_STACK;
    }

    private static /* synthetic */ Block lambda$registerWoodcutter$2(Block woodcutter) {
        return woodcutter;
    }

    private static /* synthetic */ Item lambda$onRegisterBlockItems$0(Item woodcutter) {
        return woodcutter;
    }

    public static enum VanillaWoodVariant implements StringRepresentable
    {
        OAK,
        BIRCH,
        SPRUCE,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        CRIMSON,
        WARPED,
        MANGROVE;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum BOPWoodVariant implements StringRepresentable
    {
        CHERRY,
        DEAD,
        FIR,
        HELLBARK,
        JACARANDA,
        MAGIC,
        MAHOGANY,
        PALM,
        REDWOOD,
        UMBRAN,
        WILLOW;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum TFWoodVariant implements StringRepresentable
    {
        TWILIGHT_OAK,
        CANOPY,
        MANGROVE,
        DARK,
        TIME,
        TRANSFORMATION,
        MINING,
        SORTING;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum TropicraftVariant implements StringRepresentable
    {
        PALM,
        MAHOGANY,
        BAMBOO,
        THATCH;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum BYGWoodVariant implements StringRepresentable
    {
        ASPEN,
        BAOBAB,
        BLUE_ENCHANTED,
        CHERRY,
        CIKA,
        CYPRESS,
        EBONY,
        FIR,
        GREEN_ENCHANTED,
        HOLLY,
        JACARANDA,
        MAHOGANY,
        MANGROVE,
        MAPLE,
        PINE,
        RAINBOW_EUCALYPTUS,
        REDWOOD,
        SKYRIS,
        WILLOW,
        WITCH_HAZEL,
        ZELKOVA,
        SYTHIAN,
        EMBUR,
        PALM,
        LAMENT,
        BULBIS,
        NIGHTSHADE,
        ETHER,
        IMPARIUS;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }
}

