/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.message;

import com.mrcrayfish.configured.network.MessageHelper;
import com.mrcrayfish.configured.network.play.ClientPlayHandler;
import com.mrcrayfish.configured.network.play.ServerPlayHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record MessageSyncForgeConfig(String fileName, byte[] data) {
    public static void encode(MessageSyncForgeConfig message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.fileName);
        buffer.m_130087_(message.data);
    }

    public static MessageSyncForgeConfig decode(FriendlyByteBuf buffer) {
        return new MessageSyncForgeConfig(buffer.m_130277_(), buffer.m_130052_());
    }

    public static void handle(MessageSyncForgeConfig message, Supplier<NetworkEvent.Context> supplier) {
        if (supplier.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer player = supplier.get().getSender();
            if (player != null) {
                MessageHelper.enqueueTask(supplier, () -> ServerPlayHandler.handleSyncServerConfigMessage(player, message));
            }
        } else {
            MessageHelper.enqueueTask(supplier, () -> ClientPlayHandler.handleSyncServerConfigMessage((NetworkEvent.Context)supplier.get(), message));
        }
    }
}

