/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.advancement.AdvancementTriggers;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.api.room.RoomSize;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.location.PreciseDimensionalPosition;
import dev.compactmods.machines.location.SimpleTeleporter;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.room.RoomCapabilities;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.room.history.PlayerRoomHistoryItem;
import dev.compactmods.machines.util.LocationUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;

public abstract class PlayerUtil {
    public static Optional<GameProfile> getProfileByUUID(LevelAccessor world, UUID uuid) {
        Player player = world.m_46003_(uuid);
        if (player == null) {
            return Optional.empty();
        }
        GameProfile profile = player.m_36316_();
        return Optional.of(profile);
    }

    public static void teleportPlayerIntoMachine(Level machineLevel, Player player, BlockPos machinePos) throws MissingDimensionException {
        MinecraftServer serv = machineLevel.m_7654_();
        ServerLevel compactWorld = serv.m_129880_(Dimension.COMPACT_DIMENSION);
        if (compactWorld == null) {
            throw new MissingDimensionException("Compact dimension not found; player attempted to enter machine.");
        }
        BlockEntity blockEntity = machineLevel.m_7702_(machinePos);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity tile = (CompactMachineBlockEntity)blockEntity;
            Optional<ChunkPos> targetRoom = tile.getConnectedRoom();
            boolean grantAdvancement = targetRoom.isEmpty();
            targetRoom.ifPresent(room -> {
                if (player.f_19853_.m_46472_().equals(Dimension.COMPACT_DIMENSION) && player.m_146902_().equals(room)) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        AdvancementTriggers.RECURSIVE_ROOMS.trigger(sp);
                    }
                    return;
                }
                try {
                    PreciseDimensionalPosition entry = PreciseDimensionalPosition.fromPlayer(player);
                    PlayerUtil.teleportPlayerIntoRoom(serv, player, room, grantAdvancement);
                    player.getCapability(RoomCapabilities.ROOM_HISTORY).ifPresent(hist -> hist.addHistory(new PlayerRoomHistoryItem(entry, tile.getLevelPosition())));
                }
                catch (MissingDimensionException | NonexistentRoomException e) {
                    CompactMachines.LOGGER.fatal("Critical error; could not enter a freshly-created room instance.", e);
                }
            });
        }
    }

    public static void teleportPlayerIntoRoom(MinecraftServer serv, Player player, ChunkPos room, boolean grantAdvancement) throws MissingDimensionException, NonexistentRoomException {
        ServerLevel compactDim = serv.m_129880_(Dimension.COMPACT_DIMENSION);
        IDimensionalPosition spawn = Rooms.getSpawn(serv, room);
        RoomSize roomSize = Rooms.sizeOf(serv, room);
        if (spawn == null) {
            CompactMachines.LOGGER.error("Room %s could not load spawn info.".formatted(room));
            return;
        }
        serv.m_18689_(() -> {
            Vec3 sp = spawn.getExactPosition();
            Vec3 sr = spawn.getRotation().orElse(new Vec3((double)player.f_19860_, (double)player.f_19859_, 0.0));
            if (player instanceof ServerPlayer) {
                ServerPlayer servPlayer = (ServerPlayer)player;
                servPlayer.changeDimension(compactDim, (ITeleporter)SimpleTeleporter.to(sp));
                if (grantAdvancement) {
                    AdvancementTriggers.getTriggerForMachineClaim(roomSize).trigger(servPlayer);
                }
            }
        });
    }

    public static void teleportPlayerOutOfMachine(ServerLevel world, @Nonnull ServerPlayer serverPlayer) {
        MinecraftServer serv = world.m_7654_();
        LazyOptional history = serverPlayer.getCapability(RoomCapabilities.ROOM_HISTORY);
        if (!history.isPresent()) {
            PlayerUtil.howDidYouGetThere(serverPlayer);
            return;
        }
        history.ifPresent(hist -> {
            if (hist.hasHistory()) {
                Object prevArea = hist.pop();
                IDimensionalPosition spawnPoint = prevArea.getEntryLocation();
                ServerLevel level = spawnPoint.level(serv);
                Vec3 worldPos = spawnPoint.getExactPosition();
                Vec3 entryRot = spawnPoint.getRotation().orElse(Vec3.f_82478_);
                serverPlayer.changeDimension(level, (ITeleporter)SimpleTeleporter.to(worldPos));
            } else {
                PlayerUtil.howDidYouGetThere(serverPlayer);
                hist.clear();
                PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
            }
        });
    }

    public static void howDidYouGetThere(@Nonnull ServerPlayer serverPlayer) {
        AdvancementTriggers.HOW_DID_YOU_GET_HERE.trigger(serverPlayer);
        serverPlayer.m_5661_((Component)TranslationUtil.message(Messages.HOW_DID_YOU_GET_HERE), true);
    }

    public static void teleportPlayerToRespawnOrOverworld(MinecraftServer serv, @Nonnull ServerPlayer player) {
        ServerLevel level = Optional.ofNullable(serv.m_129880_(player.m_8963_())).orElse(serv.m_129783_());
        Vec3 worldPos = LocationUtil.blockPosToVector(level.m_220360_());
        if (player.m_8961_() != null) {
            worldPos = LocationUtil.blockPosToVector(player.m_8961_());
        }
        player.changeDimension(level, (ITeleporter)SimpleTeleporter.to(worldPos));
    }
}

