/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.upgrade.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.room.upgrade.RoomUpgrade;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.upgrade.RoomUpgradeManager;
import dev.compactmods.machines.upgrade.command.RoomUpgradeArgument;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class CMUpgradeRoomCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> make() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.m_82127_((String)"upgrades").requires(cs -> cs.m_6761_(ServerConfig.changeUpgrades()));
        LiteralArgumentBuilder addRoot = Commands.m_82127_((String)"add");
        RequiredArgumentBuilder addUpgRoot = (RequiredArgumentBuilder)Commands.m_82129_((String)"upgrade", (ArgumentType)RoomUpgradeArgument.upgrade()).suggests(RoomUpgradeArgument.SUGGESTOR).executes(CMUpgradeRoomCommand::addToCurrentRoom);
        addUpgRoot.then(Commands.m_82127_((String)"current").executes(CMUpgradeRoomCommand::addToCurrentRoom));
        addRoot.then((ArgumentBuilder)addUpgRoot);
        root.then((ArgumentBuilder)addRoot);
        LiteralArgumentBuilder remRoot = Commands.m_82127_((String)"remove");
        RequiredArgumentBuilder remUpgRoot = (RequiredArgumentBuilder)Commands.m_82129_((String)"upgrade", (ArgumentType)RoomUpgradeArgument.upgrade()).suggests(RoomUpgradeArgument.SUGGESTOR).executes(CMUpgradeRoomCommand::removeFromCurrentRoom);
        remUpgRoot.then(Commands.m_82127_((String)"current").executes(CMUpgradeRoomCommand::removeFromCurrentRoom));
        remRoot.then((ArgumentBuilder)remUpgRoot);
        root.then((ArgumentBuilder)remRoot);
        return root;
    }

    private static int addToCurrentRoom(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        MinecraftServer serv = ((CommandSourceStack)ctx.getSource()).m_81377_();
        if (!level.m_46472_().equals(Dimension.COMPACT_DIMENSION)) {
            return -1;
        }
        Optional<RoomUpgrade> upg = RoomUpgradeArgument.getUpgrade(ctx, "upgrade");
        if (upg.isEmpty()) {
            return -1;
        }
        RoomUpgrade upgrade = upg.get();
        Vec3 execdAt = src.m_81371_();
        ChunkPos currChunk = new ChunkPos(new BlockPos((int)execdAt.f_82479_, (int)execdAt.f_82480_, (int)execdAt.f_82481_));
        if (!Rooms.exists(serv, currChunk)) {
            return -1;
        }
        RoomUpgradeManager manager = RoomUpgradeManager.get(level);
        if (manager.hasUpgrade(currChunk, upgrade)) {
            src.m_81352_((Component)TranslationUtil.message(Messages.ALREADY_HAS_UPGRADE));
        } else {
            boolean added = manager.addUpgrade(upgrade, currChunk);
            if (added) {
                upgrade.onAdded(level, currChunk);
                src.m_81354_((Component)TranslationUtil.message(Messages.UPGRADE_APPLIED), true);
            } else {
                src.m_81352_((Component)TranslationUtil.message(Messages.UPGRADE_ADD_FAILED));
            }
        }
        return 0;
    }

    private static int addToSpecificRoom(CommandContext<CommandSourceStack> ctx) {
        return 0;
    }

    private static int removeFromCurrentRoom(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        MinecraftServer serv = ((CommandSourceStack)ctx.getSource()).m_81377_();
        if (!level.m_46472_().equals(Dimension.COMPACT_DIMENSION)) {
            return -1;
        }
        Optional<RoomUpgrade> upg = RoomUpgradeArgument.getUpgrade(ctx, "upgrade");
        if (upg.isEmpty()) {
            return -1;
        }
        RoomUpgrade upgrade = upg.get();
        Vec3 execdAt = src.m_81371_();
        ChunkPos currChunk = new ChunkPos(new BlockPos((int)execdAt.f_82479_, (int)execdAt.f_82480_, (int)execdAt.f_82481_));
        if (!Rooms.exists(serv, currChunk)) {
            return -1;
        }
        RoomUpgradeManager manager = RoomUpgradeManager.get(level);
        if (!manager.hasUpgrade(currChunk, upgrade)) {
            src.m_81352_((Component)TranslationUtil.message(Messages.UPGRADE_NOT_PRESENT));
        } else {
            boolean removed = manager.removeUpgrade(upgrade, currChunk);
            if (removed) {
                upgrade.onRemoved(level, currChunk);
                src.m_81354_((Component)TranslationUtil.message(Messages.UPGRADE_REMOVED), true);
            } else {
                src.m_81352_((Component)TranslationUtil.message(Messages.UPGRADE_REM_FAILED));
            }
        }
        return 0;
    }

    private static int removeFromSpecificRoom(CommandContext<CommandSourceStack> ctx) {
        return 0;
    }
}

