/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.capability;

import dev.compactmods.machines.api.room.IRoomHistory;
import dev.compactmods.machines.room.RoomCapabilities;
import dev.compactmods.machines.room.capability.CMRoomHistory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerRoomHistoryCapProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final CMRoomHistory history;
    private LazyOptional<IRoomHistory> opt = LazyOptional.empty();

    public PlayerRoomHistoryCapProvider(Player player) {
        this.history = new CMRoomHistory();
        this.opt = LazyOptional.of(() -> this.history);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RoomCapabilities.ROOM_HISTORY) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("history", (Tag)this.history.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("history")) {
            this.history.clear();
            this.history.deserializeNBT(nbt.m_128437_("history", 10));
        }
    }
}

