/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.api.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class DoubleStreamExtensions {
    public static final PrimitiveCodec<DoubleStream> CODEC = new PrimitiveCodec<DoubleStream>(){

        public <T> DataResult<DoubleStream> read(DynamicOps<T> ops, T input) {
            return DoubleStreamExtensions.getDoubleStream(ops, input);
        }

        public <T> T write(DynamicOps<T> ops, DoubleStream value) {
            return (T)ops.createList(value.mapToObj(arg_0 -> ops.createDouble(arg_0)));
        }

        public String toString() {
            return "DoubleStream";
        }
    };

    public static DataResult<double[]> fixedDoubleSize(DoubleStream stream, int limit) {
        double[] limited = stream.limit(limit + 1).toArray();
        if (limited.length != limit) {
            String s = "Input is not a list of " + limit + " doubles";
            return limited.length >= limit ? DataResult.error((String)s, (Object)Arrays.copyOf(limited, limit)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)limited);
    }

    public static <T> DataResult<DoubleStream> getDoubleStream(DynamicOps<T> ops, T input) {
        return ops.getStream(input).flatMap(stream -> {
            List list = stream.collect(Collectors.toList());
            if (list.stream().allMatch(element -> ops.getNumberValue(element).result().isPresent())) {
                return DataResult.success((Object)list.stream().mapToDouble(element -> ((Number)ops.getNumberValue(element).result().get()).doubleValue()));
            }
            return DataResult.error((String)("Some elements are not doubles: " + input));
        });
    }
}

