/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.block;

import com.illusivesoulworks.comforts.common.block.BaseComfortsBlock;
import com.illusivesoulworks.comforts.common.block.RopeAndNailBlock;
import com.illusivesoulworks.comforts.common.block.entity.HammockBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HammockBlock
extends BaseComfortsBlock {
    private static final VoxelShape HAMMOCK_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
    private final DyeColor color;

    public HammockBlock(DyeColor color) {
        super(BaseComfortsBlock.BedType.HAMMOCK, color, BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60918_(SoundType.f_56745_).m_60978_(0.1f));
        this.color = color;
    }

    public static Direction getDirectionToOther(BedPart part, Direction facing) {
        return part == BedPart.FOOT ? facing : facing.m_122424_();
    }

    public static void dropRopeSupport(BlockPos pos, Direction direction, boolean isHead, Level level) {
        BlockPos ropePos = isHead ? pos.m_121945_(direction) : pos.m_121945_(direction.m_122424_());
        BlockState ropeState = level.m_8055_(ropePos);
        if (ropeState.m_60734_() instanceof RopeAndNailBlock) {
            level.m_46597_(ropePos, (BlockState)ropeState.m_61124_((Property)RopeAndNailBlock.SUPPORTING, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction direction = HammockBlock.m_49557_((BlockState)state).m_122424_();
        return switch (direction) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> HAMMOCK_SHAPE;
        };
    }

    @Override
    public void m_5707_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        super.m_5707_(level, pos, state, player);
        BedPart bedpart = (BedPart)state.m_61143_((Property)f_49440_);
        boolean isHead = bedpart == BedPart.HEAD;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos otherPos = pos.m_121945_(HammockBlock.getDirectionToOther(bedpart, direction));
        HammockBlock.dropRopeSupport(pos, direction, isHead, level);
        HammockBlock.dropRopeSupport(otherPos, direction, !isHead, level);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return null;
        }
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        FluidState ifluidstate = context.m_43725_().m_6425_(blockpos);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)BaseComfortsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_)) : null;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new HammockBlockEntity(pos, state, this.color);
    }
}

