/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.flags;

import cofh.lib.util.flags.FlagManager;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class FlagLootCondition
implements LootItemCondition {
    private final FlagManager manager;
    private final String flag;

    public FlagLootCondition(FlagManager manager, String flag) {
        this.manager = manager;
        this.flag = flag;
    }

    public boolean test(LootContext lootContext) {
        return this.manager.getFlag(this.flag).get();
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return this.manager.flagConditionType;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<FlagLootCondition> {
        private final FlagManager manager;

        public Serializer(FlagManager manager) {
            this.manager = manager;
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull FlagLootCondition value, @Nonnull JsonSerializationContext context) {
            json.addProperty("flag", value.flag);
        }

        @Nonnull
        public FlagLootCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new FlagLootCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString());
        }
    }
}

