/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class SocialUtils {
    private static final String TAG_FRIENDS = "cofh:friends";

    private SocialUtils() {
    }

    private static FriendData friends(ServerPlayer player) {
        return (FriendData)player.m_9236_().m_8895_().m_164861_(FriendData::new, FriendData::new, TAG_FRIENDS);
    }

    public static synchronized boolean addFriend(ServerPlayer player, GameProfile friend) {
        return SocialUtils.friends(player).addFriend((Player)player, friend);
    }

    public static synchronized boolean removeFriend(ServerPlayer player, GameProfile friend) {
        return SocialUtils.friends(player).removeFriend((Player)player, friend);
    }

    public static synchronized boolean clearFriendList(ServerPlayer player) {
        return SocialUtils.friends(player).clearFriendList((Player)player);
    }

    public static synchronized boolean clearAllFriendLists(ServerPlayer player) {
        return SocialUtils.friends(player).clearAllFriendLists((Player)player);
    }

    public static boolean isFriendOrSelf(GameProfile owner, ServerPlayer player) {
        return SocialUtils.friends(player).isFriendOrSelf(owner, (Player)player);
    }

    private static class FriendData
    extends SavedData {
        private final Map<String, Set<GameProfile>> friendLists = new TreeMap<String, Set<GameProfile>>();

        FriendData() {
        }

        FriendData(CompoundTag nbt) {
            for (String player : nbt.m_128431_()) {
                ListTag list = nbt.m_128437_(player, 10);
                ObjectOpenHashSet friendList = new ObjectOpenHashSet();
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag subTag = list.m_128728_(i);
                    friendList.add(new GameProfile(UUID.fromString(subTag.m_128461_("UUID")), subTag.m_128461_("Name")));
                }
                this.friendLists.put(player, (Set<GameProfile>)friendList);
            }
        }

        boolean addFriend(Player player, GameProfile friend) {
            if (player == null || friend == null) {
                return false;
            }
            String playerUUID = player.m_36316_().getId().toString();
            ObjectOpenHashSet set = this.friendLists.get(playerUUID);
            if (set == null) {
                set = new ObjectOpenHashSet();
            }
            set.add((GameProfile)friend);
            this.friendLists.put(playerUUID, (Set<GameProfile>)set);
            this.m_77762_();
            return true;
        }

        boolean removeFriend(Player player, GameProfile friend) {
            if (player == null || friend == null) {
                return false;
            }
            String playerUUID = player.m_36316_().getId().toString();
            Set<GameProfile> set = this.friendLists.get(playerUUID);
            this.m_77762_();
            return set != null && set.remove(friend);
        }

        public boolean clearFriendList(Player player) {
            if (player == null) {
                return false;
            }
            this.friendLists.remove(player.m_36316_().getId().toString());
            this.m_77762_();
            return true;
        }

        boolean clearAllFriendLists(Player player) {
            if (!player.m_20310_(4)) {
                return false;
            }
            this.friendLists.clear();
            this.m_77762_();
            return true;
        }

        boolean isFriendOrSelf(GameProfile owner, Player player) {
            if (owner == null || player == null) {
                return false;
            }
            String friendName = player.m_36316_().getName();
            if (friendName.equals(owner.getName())) {
                return true;
            }
            String playerUUID = owner.getId().toString();
            Set<GameProfile> set = this.friendLists.get(playerUUID);
            return set != null && set.contains(player.m_36316_());
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            for (Map.Entry<String, Set<GameProfile>> friendList : this.friendLists.entrySet()) {
                ListTag list = new ListTag();
                for (GameProfile friend : friendList.getValue()) {
                    CompoundTag subTag = new CompoundTag();
                    subTag.m_128359_("UUID", friend.getId().toString());
                    subTag.m_128359_("Name", friend.getName());
                    list.add((Object)subTag);
                }
                nbt.m_128365_(friendList.getKey(), (Tag)list);
            }
            return nbt;
        }
    }
}

