/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.lib.api.item.ICoFHItem;
import cofh.lib.util.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DispenserBlock;

public class ShearsItemCoFH
extends ShearsItem
implements ICoFHItem {
    protected int enchantability = 0;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";

    public ShearsItemCoFH(Item.Properties builder) {
        super(builder);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new ShearsDispenseItemBehavior());
    }

    public ShearsItemCoFH(Tier tier, Item.Properties builder) {
        this(builder);
        this.setParams(tier);
    }

    public ShearsItemCoFH setParams(Tier tier) {
        this.enchantability = tier.m_6601_();
        return this;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public ICoFHItem setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public ICoFHItem setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public ICoFHItem setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

