/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.api.item;

import cofh.core.client.CoreKeys;
import cofh.core.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;

public interface ICoFHItem
extends IForgeItem {
    public ICoFHItem setDisplayGroup(Supplier<CreativeModeTab> var1);

    public ICoFHItem setModId(String var1);

    public ICoFHItem setShowInGroups(Supplier<Boolean> var1);

    default public void addEnergyTooltip(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn, int extract, int receive, boolean creative) {
        if (extract == receive && extract > 0 || creative) {
            tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.transfer") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
        } else if (extract > 0) {
            if (receive > 0) {
                tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + "|" + StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(extract) + "|" + StringHelper.getScaledNumber(receive) + " RF/t"));
            } else {
                tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
            }
        } else if (receive > 0) {
            tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(receive) + " RF/t"));
        }
    }

    default public void addModeChangeTooltip(IMultiModeItem item, ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (item.getNumModes(stack) <= 2) {
            this.addIncrementModeChangeTooltip(item, stack, worldIn, tooltip, flagIn);
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"info.cofh.mode_change", (Object[])new Object[]{Utils.getKeynameFromKeycode(CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_()), Utils.getKeynameFromKeycode(CoreKeys.MULTIMODE_DECREMENT.getKey().m_84873_())}).m_130940_(ChatFormatting.YELLOW));
        if (CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_() == -1) {
            tooltip.add((Component)Component.m_237110_((String)"info.cofh.key_not_bound", (Object[])new Object[]{StringHelper.localize("key.cofh.mode_change_increment")}).m_130940_(ChatFormatting.RED));
        }
        if (CoreKeys.MULTIMODE_DECREMENT.getKey().m_84873_() == -1) {
            tooltip.add((Component)Component.m_237110_((String)"info.cofh.key_not_bound", (Object[])new Object[]{StringHelper.localize("key.cofh.mode_change_decrement")}).m_130940_(ChatFormatting.RED));
        }
    }

    default public void addIncrementModeChangeTooltip(IMultiModeItem item, ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"info.cofh.mode_toggle", (Object[])new Object[]{Utils.getKeynameFromKeycode(CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_())}).m_130940_(ChatFormatting.YELLOW));
        if (CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_() == -1) {
            tooltip.add((Component)Component.m_237110_((String)"info.cofh.key_not_bound", (Object[])new Object[]{StringHelper.localize("key.cofh.mode_change_increment")}).m_130940_(ChatFormatting.RED));
        }
    }

    default public boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("Active");
    }

    default public void setActive(ItemStack stack, boolean state) {
        stack.m_41784_().m_128379_("Active", state);
    }

    default public boolean hasActiveTag(ItemStack stack) {
        return stack.m_41784_().m_128441_("Active");
    }

    default public void setActive(ItemStack stack, LivingEntity entity) {
        stack.m_41784_().m_128356_("Active", entity.f_19853_.m_46467_() + 20L);
    }
}

