/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.lib.api.block.IHarvestable;
import cofh.lib.util.Utils;
import cofh.lib.util.raytracer.RayTracer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public final class AreaEffectHelper {
    private AreaEffectHelper() {
    }

    public static boolean validAreaEffectItem(ItemStack stack) {
        return stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).isPresent() || stack.m_41720_() instanceof DiggerItem;
    }

    public static boolean validAreaEffectMiningItem(ItemStack stack) {
        return stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).isPresent() || stack.m_41720_() instanceof DiggerItem;
    }

    public static ImmutableList<BlockPos> getAreaEffectBlocks(ItemStack stack, BlockPos pos, Player player) {
        int encExcavating = Utils.getItemEnchantmentLevel(Utils.getEnchantment("ensorcellation", "excavating"), stack);
        if (encExcavating > 0) {
            return AreaEffectHelper.getBreakableBlocksRadius(stack, pos, player, encExcavating);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockPos> getBucketableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.SOURCE_ONLY);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || radius <= 0) {
            return ImmutableList.of();
        }
        int yMin = -1;
        int yMax = 2 * radius - 1;
        List area = switch (traceResult.m_82434_()) {
            case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, 0, -radius), (BlockPos)pos.m_7918_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.isBucketable(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, yMin, 0), (BlockPos)pos.m_7918_(radius, yMax, 0)).filter(blockPos -> AreaEffectHelper.isBucketable(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> BlockPos.m_121990_((BlockPos)pos.m_7918_(0, yMin, -radius), (BlockPos)pos.m_7918_(0, yMax, radius)).filter(blockPos -> AreaEffectHelper.isBucketable(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        };
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0) {
            return ImmutableList.of();
        }
        int yMin = -1;
        int yMax = 2 * radius - 1;
        List area = switch (traceResult.m_82434_()) {
            case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, 0, -radius), (BlockPos)pos.m_7918_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, yMin, 0), (BlockPos)pos.m_7918_(radius, yMax, 0)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> BlockPos.m_121990_((BlockPos)pos.m_7918_(0, yMin, -radius), (BlockPos)pos.m_7918_(0, yMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        };
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableBlocksDepth(ItemStack stack, BlockPos pos, Player player, int radius, int depth) {
        List area;
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && depth <= 0) {
            return ImmutableList.of();
        }
        int dMin = depth;
        int dMax = 0;
        int yMin = -1;
        int yMax = 2 * radius - 1;
        switch (traceResult.m_82434_()) {
            case DOWN: {
                dMin = 0;
                dMax = depth;
            }
            case UP: {
                area = BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, -dMin, -radius), (BlockPos)pos.m_7918_(radius, dMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
                break;
            }
            case NORTH: {
                dMin = 0;
                dMax = depth;
            }
            case SOUTH: {
                area = BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, yMin, -dMin), (BlockPos)pos.m_7918_(radius, yMax, dMax)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
                break;
            }
            case WEST: {
                dMin = 0;
                dMax = depth;
            }
            default: {
                area = BlockPos.m_121990_((BlockPos)pos.m_7918_(-dMin, yMin, -radius), (BlockPos)pos.m_7918_(dMax, yMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            }
        }
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableBlocksLine(ItemStack stack, BlockPos pos, Player player, int length) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || length <= 0) {
            return ImmutableList.of();
        }
        switch (player.m_6350_()) {
            case SOUTH: {
                BlockPos query;
                for (int k = z + 1; k < z + length + 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); ++k) {
                    area.add(query);
                }
                break;
            }
            case WEST: {
                BlockPos query;
                for (int i = x - 1; i > x - length - 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); --i) {
                    area.add(query);
                }
                break;
            }
            case NORTH: {
                BlockPos query;
                for (int k = z - 1; k > z - length - 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); --k) {
                    area.add(query);
                }
                break;
            }
            case EAST: {
                BlockPos query;
                for (int i = x + 1; i < x + length + 1 && AreaEffectHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); ++i) {
                    area.add(query);
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getBreakableWoodenBlocksVertical(ItemStack stack, BlockPos pos, Player player, int length) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        if (length <= 0 || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || player.m_36341_()) {
            return ImmutableList.of();
        }
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return ImmutableList.of();
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        ITagManager tags = ForgeRegistries.BLOCKS.tags();
        if (tags == null) {
            return ImmutableList.of();
        }
        Predicate<BlockPos> exact = p -> world.m_8055_(p).m_60713_(block) && AreaEffectHelper.canToolAffect(tool, stack, world, p);
        Predicate<BlockPos> match = tags.getReverseTag((Object)state.m_60734_()).map(rev -> {
            if (rev.containsTag(BlockTags.f_13106_)) {
                return rev.getTagKeys().filter(key -> key.f_203868_().m_135815_().contains("_logs")).findAny().map(key -> exact.or(p -> world.m_8055_(p).m_204336_(key))).orElse(exact);
            }
            return exact;
        }).orElse(exact);
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < length; ++i) {
            mutable.m_122184_(0, 1, 0);
            if (!match.test((BlockPos)mutable)) break;
            builder.add((Object)mutable.m_7949_());
        }
        return builder.build();
    }

    public static ImmutableList<BlockPos> getPlaceableBlocksRadius(ItemStack stack, BlockPos pos, Player player, int radius) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        BlockHitResult traceResult = RayTracer.retrace(player, ClipContext.Fluid.NONE);
        if (traceResult.m_6662_() == HitResult.Type.MISS || player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0) {
            return ImmutableList.of();
        }
        int yMin = -1;
        int yMax = 2 * radius - 1;
        return ImmutableList.copyOf(switch (traceResult.m_82434_()) {
            case Direction.DOWN, Direction.UP -> BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, 0, -radius), (BlockPos)pos.m_7918_(radius, 0, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            case Direction.NORTH, Direction.SOUTH -> BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, yMin, 0), (BlockPos)pos.m_7918_(radius, yMax, 0)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
            default -> BlockPos.m_121990_((BlockPos)pos.m_7918_(0, yMin, -radius), (BlockPos)pos.m_7918_(0, yMax, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        });
    }

    public static ImmutableList<BlockPos> getBlocksCentered(ItemStack stack, BlockPos pos, Player player, int radius, int height) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        if (player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && height <= 0) {
            return ImmutableList.of();
        }
        List area = BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, -height, -radius), (BlockPos)pos.m_7918_(radius, height, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getMatureBlocksCentered(ItemStack stack, BlockPos pos, Player player, int radius, int height) {
        Level world = player.m_20193_();
        Item tool = stack.m_41720_();
        if (player.m_36341_() || !AreaEffectHelper.canToolAffect(tool, stack, world, pos) || !AreaEffectHelper.isMature(world, pos) || radius <= 0 && height <= 0) {
            return ImmutableList.of();
        }
        List area = BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, -height, -radius), (BlockPos)pos.m_7918_(radius, height, radius)).filter(blockPos -> AreaEffectHelper.canToolAffect(tool, stack, world, blockPos) && AreaEffectHelper.isMature(world, blockPos)).map(BlockPos::m_7949_).collect(Collectors.toList());
        area.remove(pos);
        return ImmutableList.copyOf(area);
    }

    private static boolean canToolAffect(Item toolItem, ItemStack toolStack, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60800_((BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        return toolItem.isCorrectToolForDrops(toolStack, state) || !state.m_60834_() && toolItem.m_8102_(toolStack, state) > 1.0f;
    }

    private static boolean canHoeAffect(Level world, BlockPos pos, boolean weeding) {
        return false;
    }

    private static boolean isBucketable(Item toolItem, ItemStack toolStack, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof BucketPickup;
    }

    public static boolean isMature(Level level, BlockPos pos) {
        return AreaEffectHelper.isMature(level, pos, level.m_8055_(pos));
    }

    public static boolean isMature(Level level, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IHarvestable) {
            IHarvestable harvestable = (IHarvestable)block;
            return harvestable.canHarvest(state);
        }
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.m_52307_(state);
        }
        if (block instanceof StemBlock) {
            return false;
        }
        if (block instanceof GrowingPlantBlock) {
            GrowingPlantBlock plant = (GrowingPlantBlock)block;
            BlockState root = level.m_8055_(pos.m_121945_(plant.f_53859_.m_122424_()));
            return root.m_60713_(plant.m_7777_());
        }
        if (block instanceof BambooBlock || block instanceof CactusBlock || block instanceof SugarCaneBlock) {
            BlockState below = level.m_8055_(pos.m_121945_(Direction.DOWN));
            return below.m_60713_(block);
        }
        if (block instanceof DoublePlantBlock) {
            return !state.m_60713_(Blocks.f_152547_);
        }
        if (block instanceof LeavesBlock) {
            return state.m_61145_((Property)LeavesBlock.f_54419_).orElse(false) == false;
        }
        Material material = state.m_60767_();
        return state.m_61145_((Property)BlockStateProperties.f_61405_).map(v -> v >= 1).or(() -> state.m_61145_((Property)BlockStateProperties.f_61406_).map(v -> v >= 2)).or(() -> state.m_61145_((Property)BlockStateProperties.f_61407_).map(v -> v >= 3)).or(() -> state.m_61145_((Property)BlockStateProperties.f_61408_).map(v -> v >= 5)).or(() -> state.m_61145_((Property)BlockStateProperties.f_61409_).map(v -> v >= 7)).or(() -> state.m_61145_((Property)BlockStateProperties.f_61410_).map(v -> v >= 15)).or(() -> state.m_61145_((Property)BlockStateProperties.f_61411_).map(v -> v >= 25)).orElse(block instanceof BigDripleafBlock || block instanceof BigDripleafStemBlock || block instanceof HugeMushroomBlock || state.m_204336_(BlockTags.f_13040_) || material.equals(Material.f_76285_) || material.equals(Material.f_164530_));
    }
}

