/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BeamParticle
extends PointToPointParticle {
    private BeamParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = time / this.duration;
        float easeCos = 0.5f * MathHelper.cos(progress * (float)Math.PI * 0.5f) + 0.5f;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        VFXHelper.alignVertical(stack, Vector3f.f_176763_, this.disp);
        VFXHelper.renderBeam(stack, buffer, packedLight, this.size * easeCos, this.c0.scaleAlpha(easeCub), this.c1.scaleAlpha(easeCub));
    }

    @Override
    public int m_6355_(float pTicks) {
        return 0xF000F0;
    }

    @Override
    public int getLightColor(float pTicks, double x, double y, double z) {
        return 0xF000F0;
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return BeamParticle::new;
    }
}

