/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.datagen;

import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.api.Element;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.common.blocks.ChemicalBlock;
import com.smashingmods.chemlib.common.items.ChemicalBlockItem;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import com.smashingmods.chemlib.registry.FluidRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "chemlib", existingFileHelper);
    }

    protected void registerModels() {
        this.generateElementModels();
        this.generateCompoundModels();
        this.generateChemicalItemModels();
        ItemRegistry.getElements().forEach(this::registerElement);
        ItemRegistry.getCompounds().forEach(this::registerCompound);
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.COMPOUND).forEach(this::registerCompoundDust);
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.DUST).forEach(dust -> this.registerItem(dust.getChemicalName(), "dust"));
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.NUGGET).forEach(nugget -> this.registerItem(nugget.getChemicalName(), "nugget"));
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.INGOT).forEach(ingot -> this.registerItem(ingot.getChemicalName(), "ingot"));
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.PLATE).forEach(plate -> {
            if (!plate.getChemicalName().equals("polyvinyl_chloride")) {
                this.registerItem(plate.getChemicalName(), "plate");
            }
        });
        FluidRegistry.getBuckets().forEach(this::registerBucket);
        ItemRegistry.getChemicalBlockItems().forEach(this::registerChemicalBlockItems);
    }

    private void generateElementModels() {
        for (String type : Arrays.asList("solid", "liquid", "gas")) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/element_%s_model", type), this.mcLoc("item/generated"))).texture("layer0", this.modLoc(String.format("items/element_%s_layer_0", type)))).texture("layer1", this.modLoc(String.format("items/element_%s_layer_1", type)));
        }
    }

    private void generateCompoundModels() {
        for (String type : Arrays.asList("solid", "liquid", "gas", "dust")) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/compound_%s_model", type), this.mcLoc("item/generated"))).texture("layer0", this.modLoc(String.format("items/compound_%s_layer_0", type)))).texture("layer1", this.modLoc(String.format("items/compound_%s_layer_1", type)));
        }
    }

    private void generateChemicalItemModels() {
        Arrays.stream(ChemicalItemType.values()).map(ChemicalItemType::m_7912_).forEach(type -> ((ItemModelBuilder)this.withExistingParent(String.format("item/chemical_%s_model", type), this.mcLoc("item/generated"))).texture("layer0", this.modLoc(String.format("items/%s", type))));
    }

    private void registerElement(Element pElement) {
        this.withExistingParent(String.format("item/%s", pElement.getChemicalName()), this.modLoc("item/builtin_entity"));
    }

    private void registerCompound(CompoundItem pCompound) {
        switch (pCompound.getMatterState()) {
            case SOLID: {
                this.withExistingParent(String.format("item/%s", pCompound.getChemicalName()), this.modLoc("item/compound_solid_model"));
                break;
            }
            case LIQUID: {
                this.withExistingParent(String.format("item/%s", pCompound.getChemicalName()), this.modLoc("item/compound_liquid_model"));
                break;
            }
            case GAS: {
                this.withExistingParent(String.format("item/%s", pCompound.getChemicalName()), this.modLoc("item/compound_gas_model"));
            }
        }
    }

    private void registerCompoundDust(ChemicalItem pItem) {
        this.withExistingParent(String.format("item/%s_dust", pItem.getChemicalName()), this.modLoc("item/compound_dust_model"));
    }

    private void registerItem(String pName, String pType) {
        this.withExistingParent(String.format("item/%s_%s", pName, pType), this.modLoc("item/builtin_entity"));
    }

    private void registerChemicalBlockItems(ChemicalBlockItem pBlockItem) {
        ChemicalBlock block = (ChemicalBlock)pBlockItem.m_40614_();
        String type = block.getBlockType().m_7912_();
        String name = String.format("item/%s_%s_block", block.getChemicalName(), type);
        ResourceLocation parent = this.modLoc(String.format("block/%s_%s_block", block.getChemicalName(), type));
        ResourceLocation texture = this.modLoc(String.format("block/%s_block", type));
        ((ItemModelBuilder)this.withExistingParent(name, parent)).texture("layer0", texture);
    }

    private void registerBucket(BucketItem pBucket) {
        String path = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pBucket)).m_135815_();
        int pieces = path.split("_").length;
        String chemicalName = "";
        for (int i = 0; i < pieces - 1; ++i) {
            chemicalName = String.format("%s%s%s", chemicalName, chemicalName.isEmpty() ? "" : "_", path.split("_")[i]);
        }
        Chemical chemical = null;
        Optional<ElementItem> optionalElement = ItemRegistry.getElementByName(chemicalName);
        Optional<CompoundItem> optionalCompound = ItemRegistry.getCompoundByName(chemicalName);
        if (optionalElement.isPresent()) {
            chemical = optionalElement.get();
        } else if (optionalCompound.isPresent()) {
            chemical = optionalCompound.get();
        }
        MatterState matterState = Objects.requireNonNull(chemical).getMatterState();
        switch (matterState) {
            case LIQUID: {
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/%s", path), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("items/bucket_layer_0"))).texture("layer1", this.modLoc("items/bucket_layer_1"));
                break;
            }
            case GAS: {
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("item/%s", path), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("items/gas_bucket_layer_0"))).texture("layer1", this.modLoc("items/gas_bucket_layer_1"));
            }
        }
    }
}

