/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.api.addons.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.smashingmods.chemlib.api.addons.datagen.ModBlockStateGenerator;
import com.smashingmods.chemlib.api.addons.datagen.ModItemModelGenerator;
import com.smashingmods.chemlib.api.addons.datagen.ModItemTagGenerator;
import com.smashingmods.chemlib.api.addons.datagen.ModLocalizationGenerator;
import com.smashingmods.chemlib.api.addons.registry.CompoundRegistration;
import com.smashingmods.chemlib.api.addons.registry.ModTracker;
import com.smashingmods.chemlib.client.events.ForgeEventHandler;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AddonRegistry {
    public static String modID;
    private CreativeModeTab bucketsTab = null;
    private CreativeModeTab compoundsTab = null;
    private boolean usedCustomBucketsTab = false;
    private boolean usedCustomCompoundsTab = false;
    public DeferredRegister<Item> COMPOUNDS;
    public DeferredRegister<Item> COMPOUND_DUSTS;
    public DeferredRegister<Fluid> FLUIDS;
    public DeferredRegister<FluidType> FLUID_TYPES;
    public DeferredRegister<Block> LIQUID_BLOCKS;
    public DeferredRegister<Item> BUCKETS;

    public AddonRegistry(String pModID) throws RuntimeException {
        modID = pModID;
        this.COMPOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)pModID);
        this.COMPOUND_DUSTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)pModID);
        this.FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)pModID);
        this.FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)pModID);
        this.LIQUID_BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)pModID);
        this.BUCKETS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)pModID);
        this.addListeners();
        ModTracker.addModRegistries(this);
    }

    public AddonRegistry(String pModID, DeferredRegister<Item> pCompounds, DeferredRegister<Item> pCompoundDusts, DeferredRegister<Fluid> pFluids, DeferredRegister<FluidType> pFluidTypes, DeferredRegister<Block> pLiquidBlocks, DeferredRegister<Item> pBuckets) throws RuntimeException {
        modID = pModID;
        this.COMPOUNDS = pCompounds;
        this.COMPOUND_DUSTS = pCompoundDusts;
        this.FLUIDS = pFluids;
        this.FLUID_TYPES = pFluidTypes;
        this.LIQUID_BLOCKS = pLiquidBlocks;
        this.BUCKETS = pBuckets;
        this.addListeners();
        ModTracker.addModRegistries(this);
    }

    private void addListeners() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::onClientSetupEvent);
        modEventBus.addListener(this::onItemColorHandlerEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderTooltip);
    }

    public static JsonObject getStreamAsJsonObject(Class<?> pCaller, String pPath) {
        return JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(Objects.requireNonNull(pCaller.getResourceAsStream(pPath))))).getAsJsonObject();
    }

    public void registerCompounds(IEventBus pEventBus, Class<?> pCaller, String pPath) {
        this.registerCompounds(pEventBus, AddonRegistry.getStreamAsJsonObject(pCaller, pPath));
    }

    public void registerCompounds(IEventBus pEventBus, JsonObject pCompoundsJson) {
        if (this.compoundsTab == null) {
            this.compoundsTab = this.makeCompoundsTab(this);
        }
        if (this.bucketsTab == null) {
            this.bucketsTab = this.makeBucketsTab(this);
        }
        while (!ModTracker.ChemlibRegistered) {
        }
        CompoundRegistration.registerCompounds(this, pCompoundsJson);
        this.register(pEventBus);
    }

    private void register(IEventBus eventBus) {
        this.COMPOUNDS.register(eventBus);
        this.COMPOUND_DUSTS.register(eventBus);
        this.FLUIDS.register(eventBus);
        this.FLUID_TYPES.register(eventBus);
        this.LIQUID_BLOCKS.register(eventBus);
        this.BUCKETS.register(eventBus);
    }

    private CreativeModeTab makeBucketsTab(final AddonRegistry pRegisters) {
        return new CreativeModeTab(String.format("%s.fluids", pRegisters.getModID())){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Items.f_42447_, 1);
            }

            public void m_6151_(@Nonnull NonNullList<ItemStack> pItems) {
                pItems.addAll(pRegisters.getSortedBuckets().stream().map(ItemStack::new).toList());
            }
        };
    }

    private CreativeModeTab makeCompoundsTab(final AddonRegistry pRegisters) {
        return new CreativeModeTab(String.format("%s.compounds", pRegisters.getModID())){

            @Nonnull
            public ItemStack m_6976_() {
                List<CompoundItem> compounds = pRegisters.getCompounds();
                return new ItemStack((ItemLike)(compounds.isEmpty() ? Items.f_41852_ : (ItemLike)compounds.get(0)), 1);
            }

            public void m_6151_(@Nonnull NonNullList<ItemStack> pItems) {
                pItems.addAll(pRegisters.getSortedCompounds().stream().map(ItemStack::new).toList());
                pItems.addAll(pRegisters.getSortedChemicalItems().stream().map(ItemStack::new).toList());
            }
        };
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.m_236039_(event.includeClient(), (DataProvider)new ModBlockStateGenerator(generator, this.getModID(), this.LIQUID_BLOCKS, event.getExistingFileHelper()));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModItemModelGenerator(generator, this, event.getExistingFileHelper()));
        generator.m_236039_(event.includeClient(), (DataProvider)new ModLocalizationGenerator(generator, this, "en_us"));
        generator.m_236039_(event.includeServer(), (DataProvider)new ModItemTagGenerator(generator, this, event.getExistingFileHelper()));
    }

    public void onClientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            this.getFluidsAsStream().forEach(fluid -> ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)RenderType.m_110451_()));
            this.getLiquidBlocksAsStream().forEach(liquidBlock -> ItemBlockRenderTypes.setRenderLayer((Block)liquidBlock, (RenderType)RenderType.m_110451_()));
        });
    }

    public void onItemColorHandlerEvent(RegisterColorHandlersEvent.Item event) {
        this.getCompounds().forEach(compound -> event.register(compound::getColor, new ItemLike[]{compound}));
        this.getCompoundItemsAsStream().forEach(item -> event.register(item::getColor, new ItemLike[]{item}));
        this.getBucketsAsStream().forEach(bucket -> event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{bucket}));
    }

    public void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        BucketItem bucket;
        Item item = event.getItemStack().m_41720_();
        if (item instanceof BucketItem && ForgeRegistries.FLUIDS.getResourceKey((Object)(bucket = (BucketItem)item).getFluid()).isPresent() && ((ResourceKey)ForgeRegistries.FLUIDS.getResourceKey((Object)bucket.getFluid()).get()).m_135782_().m_135827_().equals(this.getModID())) {
            ForgeEventHandler.gatherTooltipComponents(event, bucket);
        }
    }

    public String getModID() {
        return modID;
    }

    public void setCompoundsTab(CreativeModeTab pCompoundsTab) {
        this.compoundsTab = pCompoundsTab;
        this.usedCustomCompoundsTab = true;
    }

    public void setBucketsTab(CreativeModeTab pBucketsTab) {
        this.bucketsTab = pBucketsTab;
        this.usedCustomBucketsTab = true;
    }

    public CreativeModeTab getCompoundsTab() {
        return this.compoundsTab;
    }

    public CreativeModeTab getBucketsTab() {
        return this.bucketsTab;
    }

    public boolean usedCustomCompoundsTab() {
        return this.usedCustomCompoundsTab;
    }

    public boolean usedCustomBucketsTab() {
        return this.usedCustomBucketsTab;
    }

    public List<CompoundItem> getCompounds() {
        return this.COMPOUNDS.getEntries().stream().map(RegistryObject::get).map(item -> (CompoundItem)item).collect(Collectors.toList());
    }

    public List<CompoundItem> getSortedCompounds() {
        ArrayList<CompoundItem> compounds = new ArrayList<CompoundItem>(this.COMPOUNDS.getEntries().stream().map(RegistryObject::get).map(item -> (CompoundItem)item).toList());
        compounds.sort(Comparator.comparing(CompoundItem::getChemicalName));
        return compounds;
    }

    public Optional<CompoundItem> getCompoundByName(String pName) {
        return this.getCompounds().stream().filter(compound -> compound.getChemicalName().equals(pName)).findFirst();
    }

    public List<ChemicalItem> getSortedChemicalItems() {
        return this.getCompoundItemsAsStream().sorted(Comparator.comparing(ChemicalItem::getChemicalName)).collect(Collectors.toList());
    }

    public Stream<ChemicalItem> getCompoundItemsAsStream() {
        return this.COMPOUND_DUSTS.getEntries().stream().map(RegistryObject::get).map(item -> (ChemicalItem)item);
    }

    public Stream<Fluid> getFluidsAsStream() {
        return this.FLUIDS.getEntries().stream().map(RegistryObject::get);
    }

    public Stream<ForgeFlowingFluid.Source> getSourceFluidsAsStream() {
        return this.getFluidsAsStream().filter(fluid -> fluid instanceof ForgeFlowingFluid.Source).map(fluid -> (ForgeFlowingFluid.Source)fluid);
    }

    public Stream<LiquidBlock> getLiquidBlocksAsStream() {
        return this.LIQUID_BLOCKS.getEntries().stream().map(RegistryObject::get).map(block -> (LiquidBlock)block);
    }

    public Stream<BucketItem> getBucketsAsStream() {
        return this.BUCKETS.getEntries().stream().map(RegistryObject::get).map(item -> (BucketItem)item);
    }

    public List<BucketItem> getSortedBuckets() {
        ArrayList<BucketItem> buckets = new ArrayList<BucketItem>(this.getBucketsAsStream().toList());
        buckets.sort((b1, b2) -> b1.getFluid().getFluidType().toString().compareToIgnoreCase(b2.getFluid().getFluidType().toString()));
        return buckets;
    }
}

