/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.blockentity.TieredImporterBlockEntity;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.DiskDriveBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredImporterNetworkNode
extends TieredNetworkNode<TieredImporterNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 9;
    private static final int SPEED_INCREASE = 2;
    private final BaseItemHandler itemFilters;
    private final FluidInventory fluidFilters;
    private final UpgradeItemHandler upgrades;
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int currentSlot;
    private final CoverManager coverManager = new CoverManager((NetworkNode)this);

    public TieredImporterNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.IMPORTER, tier);
        UpgradeItem.Type[] typeArray;
        this.itemFilters = new BaseItemHandler(9 * tier.getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
        this.fluidFilters = new FluidInventory(9 * tier.getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
        int n = tier == CableTier.CREATIVE ? 0 : 4;
        if (tier == CableTier.ELITE) {
            UpgradeItem.Type[] typeArray2 = new UpgradeItem.Type[2];
            typeArray2[0] = UpgradeItem.Type.SPEED;
            typeArray = typeArray2;
            typeArray2[1] = UpgradeItem.Type.STACK;
        } else {
            UpgradeItem.Type[] typeArray3 = new UpgradeItem.Type[1];
            typeArray = typeArray3;
            typeArray3[0] = UpgradeItem.Type.SPEED;
        }
        this.upgrades = (UpgradeItemHandler)new UpgradeItemHandler(n, typeArray).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        int baseSpeed;
        int speed;
        super.update();
        if (!(this.canUpdate() && this.level.m_46749_(this.pos) && this.level.m_46749_(this.pos.m_121945_(this.getDirection())))) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && (speed = Math.max(1, this.upgrades.getSpeed(baseSpeed = 9 / this.getSpeedMultiplier(), 2))) > 1 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            this.itemUpdate();
        } else if (this.type == 1) {
            this.fluidUpdate();
        }
    }

    private int getSpeedMultiplier() {
        switch (this.getTier()) {
            case ELITE: {
                return (Integer)CableConfig.ELITE_IMPORTER_SPEED.get();
            }
            case ULTRA: {
                return (Integer)CableConfig.ULTRA_IMPORTER_SPEED.get();
            }
        }
        throw new RuntimeException("illegal tier " + this.getTier());
    }

    private boolean interactWithStacks() {
        return this.getTier() != CableTier.ELITE || this.upgrades.hasUpgrade(UpgradeItem.Type.STACK);
    }

    private void itemUpdate() {
        BlockEntity facing = this.getFacingBlockEntity();
        if (facing == null || facing instanceof DiskDriveBlockEntity) {
            return;
        }
        IItemHandler handler = LevelUtils.getItemHandler((BlockEntity)facing, (Direction)this.getDirection().m_122424_());
        if (handler == null || handler.getSlots() <= 0) {
            return;
        }
        if (this.currentSlot >= handler.getSlots()) {
            this.currentSlot = 0;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            while (this.doItemExtraction(handler)) {
            }
        } else {
            this.doItemExtraction(handler);
        }
    }

    private boolean doItemExtraction(IItemHandler handler) {
        int startSlot = this.currentSlot;
        do {
            int interactionCount;
            ItemStack result;
            ItemStack stack = handler.getStackInSlot(this.currentSlot);
            if (this.network.getItemStorageCache().getList().getCount((Object)stack) == Integer.MAX_VALUE) {
                return false;
            }
            if (!stack.m_41619_() && IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)stack) && !(result = handler.extractItem(this.currentSlot, interactionCount = this.interactWithStacks() ? stack.m_41613_() : 1, true)).m_41619_()) {
                int remaining = this.network.insertItem(result, result.m_41613_(), Action.SIMULATE).m_41613_();
                int inserted = result.m_41613_() - remaining;
                if (inserted > 0) {
                    result = handler.extractItem(this.currentSlot, inserted, false);
                    this.network.insertItemTracked(result, result.m_41613_());
                    return true;
                }
            }
            if (++this.currentSlot < handler.getSlots()) continue;
            this.currentSlot = 0;
        } while (this.currentSlot != startSlot);
        return false;
    }

    private void fluidUpdate() {
        IFluidHandler handler = LevelUtils.getFluidHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_());
        BlockEntity facing = this.getFacingBlockEntity();
        if (facing == null) {
            return;
        }
        if (handler == null) {
            return;
        }
        if (this.currentSlot >= handler.getTanks()) {
            this.currentSlot = 0;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            while (this.doFluidExtraction(handler)) {
            }
        } else {
            this.doFluidExtraction(handler);
        }
    }

    private boolean doFluidExtraction(IFluidHandler handler) {
        int startSlot = this.currentSlot;
        if (handler.getTanks() != 0) {
            do {
                FluidStack stack = handler.getFluidInTank(this.currentSlot);
                if (this.network.getFluidStorageCache().getList().getCount((Object)stack) == Integer.MAX_VALUE) {
                    return false;
                }
                if (!stack.isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)stack)) {
                    int interactionAmount = this.interactWithStacks() ? (this.getTier() == CableTier.CREATIVE ? stack.getAmount() : 64000) : 1000;
                    FluidStack toExtract = stack.copy();
                    toExtract.setAmount(interactionAmount);
                    FluidStack result = handler.drain(toExtract, IFluidHandler.FluidAction.SIMULATE);
                    if (!result.isEmpty()) {
                        int remaining = this.network.insertFluid(result, result.getAmount(), Action.SIMULATE).getAmount();
                        int inserted = result.getAmount() - remaining;
                        if (inserted > 0) {
                            toExtract = stack.copy();
                            toExtract.setAmount(inserted);
                            result = handler.drain(toExtract, IFluidHandler.FluidAction.EXECUTE);
                            FluidStack actualRemainder = this.network.insertFluidTracked(result, result.getAmount());
                            if (!actualRemainder.isEmpty()) {
                                result.shrink(actualRemainder.getAmount());
                            }
                            return true;
                        }
                    }
                }
                if (++this.currentSlot < handler.getTanks()) continue;
                this.currentSlot = 0;
            } while (this.currentSlot != startSlot);
            return false;
        }
        return false;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.upgrades;
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TieredImporterBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

