/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.init;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.gui.TieredConstructorScreen;
import com.YTrollman.CableTiers.gui.TieredDestructorScreen;
import com.YTrollman.CableTiers.gui.TieredDiskManipulatorScreen;
import com.YTrollman.CableTiers.gui.TieredExporterScreen;
import com.YTrollman.CableTiers.gui.TieredImporterScreen;
import com.YTrollman.CableTiers.gui.TieredRequesterScreen;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.baked.CableCoverBakedModel;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEventHandler {
    private static final BakedModelOverrideRegistry BAKED_MODEL_OVERRIDE_REGISTRY = new BakedModelOverrideRegistry();

    public ClientEventHandler() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    public void init(FMLClientSetupEvent event) {
        for (CableTier tier : CableTier.VALUES) {
            MenuScreens.m_96206_(ContentType.EXPORTER.getContainerType(tier), TieredExporterScreen::new);
            MenuScreens.m_96206_(ContentType.IMPORTER.getContainerType(tier), TieredImporterScreen::new);
            MenuScreens.m_96206_(ContentType.CONSTRUCTOR.getContainerType(tier), TieredConstructorScreen::new);
            MenuScreens.m_96206_(ContentType.DESTRUCTOR.getContainerType(tier), TieredDestructorScreen::new);
            MenuScreens.m_96206_(ContentType.DISK_MANIPULATOR.getContainerType(tier), TieredDiskManipulatorScreen::new);
            MenuScreens.m_96206_(ContentType.REQUESTER.getContainerType(tier), TieredRequesterScreen::new);
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.EXPORTER.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.IMPORTER.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.CONSTRUCTOR.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
            BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("cabletiers", ContentType.DESTRUCTOR.getName(tier)), (base, registry) -> new CableCoverBakedModel(base));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelEvent.BakingCompleted e) {
        for (ResourceLocation id : e.getModels().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = BAKED_MODEL_OVERRIDE_REGISTRY.get(new ResourceLocation(id.m_135827_(), id.m_135815_()));
            if (factory == null) continue;
            e.getModels().put(id, factory.create((BakedModel)e.getModels().get(id), e.getModels()));
        }
    }
}

