/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimulationDescription;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.Battery;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.CoolantTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.FuelTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.SimUtil;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector2ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.HeatBody;

public abstract class BaseReactorSimulation
implements IReactorSimulation {
    protected final int x;
    protected final int y;
    protected final int z;
    protected final ReactorModeratorRegistry.IModeratorProperties defaultModeratorProperties;
    protected final ReactorModeratorRegistry.IModeratorProperties[][][] moderatorProperties;
    protected final SimUtil.ControlRod[][] controlRodsXZ;
    protected final SimUtil.ControlRod[] controlRods;
    protected final double fuelToCasingRFKT;
    protected final double fuelToManifoldSurfaceArea;
    protected final double stackToCoolantSystemRFKT;
    protected final double casingToAmbientRFKT;
    protected final HeatBody fuelHeat = new HeatBody();
    protected final HeatBody stackHeat = new HeatBody();
    protected final HeatBody ambientHeat = new HeatBody();
    @Nullable
    protected final Battery battery;
    @Nullable
    protected final CoolantTank coolantTank;
    protected final HeatBody output;
    protected final FuelTank fuelTank;
    protected double fuelFertility = 1.0;

    /*
     * WARNING - void declaration
     */
    protected BaseReactorSimulation(SimulationDescription simulationDescription) {
        this.x = simulationDescription.x();
        this.y = simulationDescription.y();
        this.z = simulationDescription.z();
        this.defaultModeratorProperties = simulationDescription.defaultModeratorProperties();
        this.moderatorProperties = new ReactorModeratorRegistry.IModeratorProperties[this.x][this.y][this.z];
        this.controlRodsXZ = new SimUtil.ControlRod[this.x][this.z];
        this.controlRods = new SimUtil.ControlRod[simulationDescription.controlRodCount()];
        int currentControlRodIndex = 0;
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.z; ++j) {
                SimUtil.ControlRod controlRod;
                if (!simulationDescription.isControlRodAt(i, j)) continue;
                this.controlRodsXZ[i][j] = controlRod = new SimUtil.ControlRod(i, j);
                this.controlRods[currentControlRodIndex++] = controlRod;
            }
        }
        if (simulationDescription.passivelyCooled()) {
            this.battery = new Battery(((long)(this.x + 2) * (long)(this.y + 2) * (long)(this.z + 2) - (long)this.x * (long)this.y * (long)this.z) * Config.CONFIG.Reactor.PassiveBatteryPerExternalBlock);
            this.output = this.battery;
            this.coolantTank = null;
        } else {
            long perSideCapacity = (long)(this.controlRods.length * this.y) * Config.CONFIG.Reactor.CoolantTankAmountPerFuelRod;
            this.coolantTank = new CoolantTank(perSideCapacity += (long)simulationDescription.manifoldCount() * Config.CONFIG.Reactor.CoolantTankAmountPerFuelRod, simulationDescription.defaultModeratorProperties());
            this.output = this.coolantTank;
            this.battery = null;
        }
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                for (int k = 0; k < this.z; ++k) {
                    void var5_15;
                    void var5_11;
                    ReactorModeratorRegistry.IModeratorProperties iModeratorProperties = simulationDescription.moderatorPropertiesAt(i, j, k);
                    if (simulationDescription.isManifoldAt(i, j, k)) {
                        CoolantTank coolantTank = this.coolantTank;
                    }
                    if (var5_11 == null) {
                        ReactorModeratorRegistry.IModeratorProperties iModeratorProperties2 = simulationDescription.defaultModeratorProperties();
                    }
                    if (this.controlRodsXZ[i][k] != null) {
                        Object var5_14 = null;
                    }
                    this.moderatorProperties[i][j][k] = var5_15;
                }
            }
        }
        this.fuelTank = new FuelTank(Config.CONFIG.Reactor.PerFuelRodCapacity * (long)this.controlRods.length * (long)this.y);
        double fuelToCasingRFKT = 0.0;
        int fuelToManifoldSurfaceArea = 0;
        for (SimUtil.ControlRod controlRod : this.controlRods) {
            for (int i = 0; i < this.y; ++i) {
                for (Vector2ic direction : SimUtil.cardinalDirections) {
                    if (controlRod.x + direction.x() < 0 || controlRod.x + direction.x() >= this.x || controlRod.z + direction.y() < 0 || controlRod.z + direction.y() >= this.z) {
                        fuelToCasingRFKT += Config.CONFIG.Reactor.CasingHeatTransferRFMKT;
                        continue;
                    }
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[controlRod.x + direction.x()][i][controlRod.z + direction.y()];
                    if (properties == null) continue;
                    if (properties instanceof CoolantTank) {
                        ++fuelToManifoldSurfaceArea;
                        continue;
                    }
                    fuelToCasingRFKT += properties.heatConductivity();
                }
            }
        }
        fuelToCasingRFKT *= Config.CONFIG.Reactor.FuelToStackRFKTMultiplier;
        double d = 2 * (this.x * this.y + this.x * this.z + this.z * this.y);
        for (int i = 0; i < this.x; ++i) {
            for (int j = 0; j < this.y; ++j) {
                for (int k = 0; k < this.z; ++k) {
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[i][j][k];
                    if (!(properties instanceof CoolantTank)) continue;
                    for (Vector3ic axisDirection : SimUtil.axisDirections) {
                        int neighborX = i + axisDirection.x();
                        int neighborY = j + axisDirection.y();
                        int neighborZ = k + axisDirection.z();
                        if (neighborX < 0 || neighborX >= this.x || neighborY < 0 || neighborY >= this.y || neighborZ < 0 || neighborZ >= this.z) {
                            d -= 1.0;
                            continue;
                        }
                        ReactorModeratorRegistry.IModeratorProperties neighborProperties = this.moderatorProperties[neighborX][neighborY][neighborZ];
                        if (neighborProperties instanceof IReactorSimulation.ICoolantTank) continue;
                        d += 1.0;
                    }
                }
            }
        }
        d *= Config.CONFIG.Reactor.StackToCoolantRFMKT;
        if (simulationDescription.passivelyCooled()) {
            d *= Config.CONFIG.Reactor.PassiveCoolingTransferEfficiency;
        }
        this.casingToAmbientRFKT = (double)(2 * ((this.x + 2) * (this.y + 2) + (this.x + 2) * (this.z + 2) + (this.z + 2) * (this.y + 2))) * Config.CONFIG.Reactor.StackToAmbientRFMKT;
        this.fuelToCasingRFKT = fuelToCasingRFKT;
        this.fuelToManifoldSurfaceArea = fuelToManifoldSurfaceArea;
        this.stackToCoolantSystemRFKT = d;
        this.fuelHeat.setRfPerKelvin((double)(this.controlRods.length * this.y) * Config.CONFIG.Reactor.RodFEPerUnitVolumeKelvin);
        this.stackHeat.setRfPerKelvin((double)(this.x * this.y * this.z) * Config.CONFIG.Reactor.RodFEPerUnitVolumeKelvin);
        this.ambientHeat.setInfinite(true);
        this.ambientHeat.setTemperature(simulationDescription.ambientTemperature());
        this.stackHeat.setTemperature(simulationDescription.ambientTemperature());
        this.fuelHeat.setTemperature(simulationDescription.ambientTemperature());
        if (this.battery != null) {
            this.battery.setTemperature(simulationDescription.ambientTemperature());
        }
    }

    @Override
    public void tick(boolean active) {
        double toBurn = 0.0;
        if (active) {
            toBurn = this.radiate();
        } else {
            this.fuelTank.burn(0.0);
        }
        double denominator = Config.CONFIG.Reactor.FuelFertilityDecayDenominator;
        if (!active) {
            denominator *= Config.CONFIG.Reactor.FuelFertilityDecayDenominatorInactiveMultiplier;
        }
        this.fuelFertility = Math.max(0.0, this.fuelFertility - Math.max(Config.CONFIG.Reactor.FuelFertilityMinimumDecay, this.fuelFertility / denominator));
        this.fuelHeat.transferWith(this.stackHeat, this.fuelToCasingRFKT + this.fuelToManifoldSurfaceArea * (this.coolantTank == null ? this.defaultModeratorProperties : this.coolantTank).heatConductivity());
        this.output.transferWith(this.stackHeat, this.stackToCoolantSystemRFKT);
        this.stackHeat.transferWith(this.ambientHeat, this.casingToAmbientRFKT);
        if (active) {
            this.startNextRadiate();
            this.fuelTank.burn(toBurn);
        }
    }

    protected abstract double radiate();

    protected void startNextRadiate() {
    }

    @Override
    @Nullable
    public IReactorSimulation.IBattery battery() {
        return this.battery;
    }

    @Override
    @Nullable
    public IReactorSimulation.ICoolantTank coolantTank() {
        return this.coolantTank;
    }

    @Override
    public IReactorSimulation.IFuelTank fuelTank() {
        return this.fuelTank;
    }

    @Override
    @Nullable
    public IReactorSimulation.ControlRod controlRodAt(int x, int z) {
        if (x < 0 || x >= this.x || z < 0 || z >= this.z) {
            return null;
        }
        return this.controlRodsXZ[x][z];
    }

    @Override
    public double fertility() {
        if (this.fuelFertility <= 1.0) {
            return 1.0;
        }
        return Math.log10(this.fuelFertility) + 1.0;
    }

    @Override
    public double fuelHeat() {
        return this.fuelHeat.temperature();
    }

    @Override
    public double stackHeat() {
        return this.stackHeat.temperature();
    }

    @Override
    public double ambientTemperature() {
        return this.ambientHeat.temperature();
    }

    @Nullable
    public PhosphophylliteCompound save() {
        PhosphophylliteCompound compound = new PhosphophylliteCompound();
        compound.put("fuelTank", this.fuelTank.save());
        if (this.coolantTank != null) {
            compound.put("coolantTank", this.coolantTank.save());
        }
        if (this.battery != null) {
            compound.put("battery", this.battery.save());
        }
        compound.put("fuelFertility", this.fuelFertility);
        compound.put("fuelHeat", this.fuelHeat.temperature());
        compound.put("reactorHeat", this.stackHeat.temperature());
        return compound;
    }

    public void load(@Nonnull PhosphophylliteCompound compound) {
        this.fuelTank.load(compound.getCompound("fuelTank"));
        if (this.coolantTank != null) {
            this.coolantTank.load(compound.getCompound("coolantTank"));
        }
        if (this.battery != null) {
            this.battery.load(compound.getCompound("battery"));
        }
        this.fuelFertility = compound.getDouble("fuelFertility");
        this.fuelHeat.setTemperature(compound.getDouble("fuelHeat"));
        this.stackHeat.setTemperature(compound.getDouble("reactorHeat"));
    }
}

