/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.platform.Services;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public class ExplorationMapFunctionLogic {
    private static final Cache<ItemStack, Component> MAP_NAME_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build();

    private ExplorationMapFunctionLogic() {
    }

    public static void cacheName(ItemStack stack, Component name) {
        MAP_NAME_CACHE.put((Object)stack, (Object)name);
    }

    public static Component getCachedName(ItemStack stack) {
        Component name = (Component)MAP_NAME_CACHE.getIfPresent((Object)stack);
        MAP_NAME_CACHE.invalidate((Object)stack);
        return name;
    }

    public static void handleLocationFound(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType, BlockPos invPos) {
        if (pos == null) {
            ALConstants.logInfo("No location found - invalidating map stack", new Object[0]);
            Services.EXPLORATION_MAP_FUNCTION_LOGIC.invalidateMap(mapStack, level, invPos);
        } else {
            ALConstants.logInfo("Location found - updating treasure map in chest", new Object[0]);
            Services.EXPLORATION_MAP_FUNCTION_LOGIC.updateMap(mapStack, level, pos, scale, destinationType, invPos, ExplorationMapFunctionLogic.getCachedName(mapStack));
        }
    }

    public static ItemStack updateMapAsync(ServerLevel level, BlockPos blockPos, int scale, int searchRadius, boolean skipKnownStructures, MapDecoration.Type destinationType, TagKey<Structure> destination) {
        ItemStack mapStack = CommonLogic.createEmptyMap();
        AsyncLocator.locate(level, destination, blockPos, searchRadius, skipKnownStructures).thenOnServerThread(pos -> ExplorationMapFunctionLogic.handleLocationFound(mapStack, level, pos, scale, destinationType, blockPos));
        return mapStack;
    }
}

