/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.mixins.MapItemAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class CommonLogic {
    private static final String MAP_HOVER_NAME_KEY = "menu.working";
    private static final String KEY_LOCATING = "asynclocator.locating";

    private CommonLogic() {
    }

    public static ItemStack createEmptyMap() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42573_);
        stack.m_41714_((Component)Component.m_237115_((String)MAP_HOVER_NAME_KEY));
        stack.m_41700_(KEY_LOCATING, (Tag)ByteTag.f_128257_);
        return stack;
    }

    public static boolean isEmptyPendingMap(ItemStack stack) {
        return stack.m_150930_(Items.f_42573_) && stack.m_41782_() && stack.m_41783_().m_128441_(KEY_LOCATING);
    }

    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType) {
        CommonLogic.updateMap(mapStack, level, pos, scale, destinationType, (Component)null);
    }

    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType, String displayName) {
        CommonLogic.updateMap(mapStack, level, pos, scale, destinationType, (Component)Component.m_237115_((String)displayName));
    }

    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType, Component displayName) {
        MapItemAccess.callCreateAndStoreSavedData(mapStack, (Level)level, pos.m_123341_(), pos.m_123343_(), scale, true, true, (ResourceKey<Level>)level.m_46472_());
        MapItem.m_42850_((ServerLevel)level, (ItemStack)mapStack);
        MapItemSavedData.m_77925_((ItemStack)mapStack, (BlockPos)pos, (String)"+", (MapDecoration.Type)destinationType);
        if (displayName != null) {
            mapStack.m_41714_(displayName);
        }
        mapStack.m_41749_(KEY_LOCATING);
    }

    public static void broadcastChestChanges(ServerLevel level, BlockEntity be) {
        if (!(be instanceof ChestBlockEntity)) {
            return;
        }
        level.m_6907_().forEach(player -> {
            ChestMenu chestMenu;
            AbstractContainerMenu container = player.f_36096_;
            if (container instanceof ChestMenu && (chestMenu = (ChestMenu)container).m_39261_() == be) {
                chestMenu.m_38946_();
            }
        });
    }
}

