/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import top.theillusivec4.curios.api.SlotContext;

public class RunningShoesItem
extends CurioItem {
    private static final AttributeModifier STEP_HEIGHT_BONUS = new AttributeModifier(UUID.fromString("4a312f09-78e0-4f3a-95c2-07ed63212472"), "artifacts:running_shoes_step_height", 0.5, AttributeModifier.Operation.ADDITION);

    public RunningShoesItem() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
    }

    private static AttributeModifier getSpeedBonus() {
        double speedMultiplier = (Double)ModConfig.server.runningShoes.speedMultiplier.get();
        return new AttributeModifier(UUID.fromString("ac7ab816-2b08-46b6-879d-e5dea34ff305"), "artifacts:running_shoes_movement_speed", speedMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isEquippedBy((LivingEntity)event.player)) {
            AttributeInstance stepHeight = event.player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            AttributeInstance movementSpeed = event.player.m_21051_(Attributes.f_22279_);
            AttributeModifier movementSpeedBonus = RunningShoesItem.getSpeedBonus();
            if (movementSpeed != null && movementSpeed.m_22109_(movementSpeedBonus)) {
                movementSpeed.m_22130_(movementSpeedBonus);
            }
            if (stepHeight != null && stepHeight.m_22109_(STEP_HEIGHT_BONUS)) {
                stepHeight.m_22130_(STEP_HEIGHT_BONUS);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!ModConfig.server.isCosmetic(this)) {
            LivingEntity entity = slotContext.entity();
            AttributeInstance stepHeight = entity.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            AttributeInstance movementSpeed = entity.m_21051_(Attributes.f_22279_);
            AttributeModifier speedBonus = RunningShoesItem.getSpeedBonus();
            if (entity.m_20142_()) {
                if (!movementSpeed.m_22109_(speedBonus)) {
                    movementSpeed.m_22118_(speedBonus);
                }
                if (!stepHeight.m_22109_(STEP_HEIGHT_BONUS) && entity instanceof Player) {
                    stepHeight.m_22118_(STEP_HEIGHT_BONUS);
                }
                if (entity.f_19797_ % 20 == 0) {
                    this.damageStack(slotContext, stack);
                }
            } else {
                if (movementSpeed.m_22109_(speedBonus)) {
                    movementSpeed.m_22130_(speedBonus);
                }
                if (stepHeight.m_22109_(STEP_HEIGHT_BONUS)) {
                    stepHeight.m_22130_(STEP_HEIGHT_BONUS);
                }
            }
        }
    }
}

