/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.api.IPropagator;
import alexthw.ars_elemental.common.entity.spells.EntityCurvedProjectile;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.glyphs.MethodCurvedProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagatorArc
extends ElementalAbstractEffect
implements IPropagator {
    public static PropagatorArc INSTANCE = new PropagatorArc();

    public PropagatorArc() {
        super("propagator_arc", "Propagate Arc");
    }

    public Integer getTypeIndex() {
        return 8;
    }

    @Override
    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        Vec3 pos = hitResult.m_82450_();
        ArrayList<EntityCurvedProjectile> projectiles = new ArrayList<EntityCurvedProjectile>();
        EntityCurvedProjectile projectileSpell = new EntityCurvedProjectile(world, resolver);
        projectileSpell.m_146884_(pos.m_82520_(0.0, 1.0, 0.0));
        projectiles.add(projectileSpell);
        int numSplits = stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        float sizeRatio = shooter.m_20192_() / 1.62f;
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.m_6350_().m_122427_();
            if (i % 2 == 0) {
                offset = offset.m_122424_();
            }
            BlockPos projPos = new BlockPos(pos).m_5484_(offset, i).m_7637_(0.0, 1.5 * (double)sizeRatio, 0.0);
            EntityCurvedProjectile entityCurvedProjectile = new EntityCurvedProjectile(world, resolver);
            entityCurvedProjectile.m_6034_(projPos.m_123341_(), projPos.m_123342_(), projPos.m_123343_());
            projectiles.add(entityCurvedProjectile);
        }
        float velocity = MethodCurvedProjectile.getProjectileSpeed(stats);
        Vec3 direction = pos.m_82546_(shooter.m_20182_());
        IWrappedCaster iWrappedCaster = resolver.spellContext.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tc = (TileCaster)iWrappedCaster;
            BlockEntity blockEntity = tc.getTile();
            if (blockEntity instanceof RotatingTurretTile) {
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                direction = rotatingTurretTile.getShootAngle();
            } else {
                direction = new Vec3(((Direction)tc.getTile().m_58900_().m_61143_((Property)BasicSpellTurret.FACING)).m_122432_());
            }
        }
        for (EntityProjectileSpell entityProjectileSpell : projectiles) {
            entityProjectileSpell.m_146884_(entityProjectileSpell.m_20182_().m_82520_(0.0, 0.25 * (double)sizeRatio, 0.0));
            if (!(shooter instanceof FakePlayer)) {
                entityProjectileSpell.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, 0.3f);
            } else {
                entityProjectileSpell.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.8f);
            }
            world.m_7967_((Entity)entityProjectileSpell);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 200;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodCurvedProjectile.INSTANCE.getCompatibleAugments();
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

