/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectPhantom
extends ElementalAbstractEffect
implements IDamageEffect {
    public static EffectPhantom INSTANCE = new EffectPhantom();

    public EffectPhantom() {
        super("phantom_grasp", "Phantom Grasp");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2.m_213877_() || entity2.m_21223_() <= 0.0f) {
                return;
            }
            if (spellStats.hasBuff((AbstractAugment)AugmentExtendTime.INSTANCE)) {
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19612_, (int)(100.0 * (1.0 + spellStats.getDurationMultiplier())), (int)Math.max(0.0, spellStats.getAmpMultiplier()), false, false));
            }
            float healVal = (float)((Double)this.GENERIC_DOUBLE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
            if (entity2.m_21222_()) {
                entity2.m_5634_(healVal);
            } else {
                this.attemptDamage(world, shooter, spellStats, spellContext, resolver, (Entity)entity2, this.buildDamageSource(world, shooter).m_19389_(), healVal);
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    player.m_36399_((float)(2.5 * (1.0 + spellStats.getAmpMultiplier())));
                }
            }
        }
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 3);
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericDouble(builder, 3.0, "Base heal amount", "base_heal");
        this.addAmpConfig(builder, 3.0);
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{ArsNouveauRegistry.NECROMANCY});
    }

    public boolean canDamage(LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, @NotNull Entity entity) {
        LivingEntity living;
        return super.canDamage(shooter, stats, spellContext, resolver, entity) && (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_21222_());
    }

    public int getDefaultManaCost() {
        return 50;
    }

    public String getBookDescription() {
        return "Heals a small amount of health to undead. When used on living beings, the spell will deal an equal amount of magic damage and consume hunger. Applies Hunger instead if augmented with Extend Time.";
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentFortune.INSTANCE, AugmentExtendTime.INSTANCE});
    }
}

