/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHomingProjectile
extends EntityProjectileSpell {
    List<Predicate<LivingEntity>> ignore;
    LivingEntity target;

    public void setIgnored(List<Predicate<LivingEntity>> ignore) {
        this.ignore = ignore;
    }

    public List<Predicate<LivingEntity>> getIgnored() {
        return this.ignore;
    }

    public int getExpirationTime() {
        return MethodHomingProjectile.INSTANCE.getProjectileLifespan() * 20;
    }

    public EntityHomingProjectile(Level world, SpellResolver resolver) {
        super((EntityType)ModEntities.HOMING_PROJECTILE.get(), world, resolver);
    }

    public EntityHomingProjectile(EntityType<EntityHomingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.age > this.getExpirationTime() / 2 && this.target != null && this.m_20280_((Entity)this.target) < 1.0) {
            this.m_5790_(new EntityHitResult((Entity)this.target));
        }
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
    }

    protected void attemptRemoval() {
        super.attemptRemoval();
        if (this.pierceLeft >= 0) {
            this.age += 300;
        }
    }

    public void tickNextPosition() {
        if (!this.m_213877_()) {
            if (this.target != null && (!this.target.m_6084_() || this.target.m_20280_((Entity)this) > 50.0)) {
                this.target = null;
            }
            if (this.target == null && this.f_19797_ % 5 == 0) {
                List entities = this.m_37282_() instanceof Player ? this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), e -> this.shouldTarget((LivingEntity)e) && EntityHomingProjectile.glowCheck(e)) : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), this::shouldTarget);
                if (entities.isEmpty() && this.target == null) {
                    super.tickNextPosition();
                } else if (!entities.isEmpty()) {
                    this.target = entities.stream().filter(e -> e.m_20280_((Entity)this) < 50.0).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this))).orElse(this.target);
                }
            }
            if (this.target != null) {
                this.homeTo(this.target.m_20183_());
            } else {
                super.tickNextPosition();
            }
        }
    }

    protected boolean m_5603_(Entity entity) {
        boolean b = super.m_5603_(entity);
        if (entity instanceof LivingEntity) {
            b &= this.shouldTarget((LivingEntity)entity);
        }
        return b;
    }

    private boolean shouldTarget(LivingEntity e) {
        if (this.ignore == null) {
            return false;
        }
        for (Predicate<LivingEntity> p : this.getIgnored()) {
            if (!p.test(e)) continue;
            return false;
        }
        return true;
    }

    private void homeTo(BlockPos dest) {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        double motionX = this.m_20184_().f_82479_;
        double motionY = this.m_20184_().f_82480_;
        double motionZ = this.m_20184_().f_82481_;
        if (dest.m_123341_() != 0 || dest.m_123342_() != 0 || dest.m_123343_() != 0) {
            double targetX = (double)dest.m_123341_() + 0.5;
            double targetY = (double)dest.m_123342_() + 0.75;
            double targetZ = (double)dest.m_123343_() + 0.5;
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.m_82553_();
            targetVector = targetVector.m_82490_(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = (3.0 - length) * 0.3;
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.f_82479_;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.f_82480_;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.f_82481_;
        }
        this.m_6034_(posX += motionX, posY += motionY, posZ += motionZ);
        this.m_20334_(motionX, motionY, motionZ);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.HOMING_PROJECTILE.get();
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && result instanceof BlockHitResult) {
            BlockState state;
            BlockHitResult blockRaytraceResult = (BlockHitResult)result;
            if (!(this.m_213877_() || this.hitList.contains(((BlockHitResult)result).m_82425_()) || (state = this.f_19853_.m_8055_(blockRaytraceResult.m_82425_())).m_60734_() != Blocks.f_50142_ && state.m_60734_() != Blocks.f_50257_)) {
                return;
            }
        }
        super.m_6532_(result);
    }

    public static boolean glowCheck(LivingEntity e) {
        if (((Boolean)ConfigHandler.Common.HOMING_GLOWING.get()).booleanValue()) {
            return e.m_21023_(MobEffects.f_19619_);
        }
        return true;
    }
}

