/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client;

import alexthw.ars_elemental.common.blocks.ElementalSpellTurretTile;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.GeoBlockRenderer;

public class ElementalTurretRenderer<TL extends ElementalSpellTurretTile>
extends GeoBlockRenderer<TL> {
    public static AnimatedGeoModel modelFire = new TurretModel("fire");
    public static AnimatedGeoModel modelWater = new TurretModel("water");
    public static AnimatedGeoModel modelAir = new TurretModel("air");
    public static AnimatedGeoModel modelEarth = new TurretModel("earth");
    public static AnimatedGeoModel modelShaper = new TurretModel("manipulation");

    public ElementalTurretRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, modelFire);
    }

    public void render(GeoModel model, TL animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.m_85836_();
        Direction direction = (Direction)animatable.m_58900_().m_61143_((Property)BasicSpellTurret.FACING);
        if (direction == Direction.UP) {
            matrixStackIn.m_85837_(0.0, -0.5, -0.5);
        } else if (direction == Direction.DOWN) {
            matrixStackIn.m_85837_(0.0, -0.5, 0.5);
        }
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85849_();
    }

    public static GenericItemBlockRenderer getISTER(String element) {
        AnimatedGeoModel model = switch (element) {
            case "fire" -> modelFire;
            case "water" -> modelWater;
            case "air" -> modelAir;
            case "earth" -> modelEarth;
            default -> modelShaper;
        };
        return new GenericItemBlockRenderer(model);
    }

    public ResourceLocation getTextureLocation(TL instance) {
        return new ResourceLocation("ars_elemental", "textures/block/" + ((ElementalSpellTurretTile)((Object)instance)).getSchool().getId() + "_turret.png");
    }

    public static class TurretModel<T extends ElementalSpellTurretTile>
    extends AnimatedGeoModel<T> {
        final String element;

        public TurretModel(String element) {
            this.element = element;
        }

        public ResourceLocation getModelResource(T t) {
            return new ResourceLocation("ars_nouveau", "geo/basic_spell_turret.geo.json");
        }

        public ResourceLocation getTextureResource(T t) {
            return new ResourceLocation("ars_elemental", "textures/block/" + this.element + "_turret.png");
        }

        public ResourceLocation getAnimationResource(T t) {
            return new ResourceLocation("ars_nouveau", "animations/basic_spell_turret_animations.json");
        }
    }
}

