/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental;

import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.common.entity.familiars.FirenandoFamiliar;
import alexthw.ars_elemental.common.entity.familiars.FirenandoHolder;
import alexthw.ars_elemental.common.entity.familiars.MermaidHolder;
import alexthw.ars_elemental.common.entity.spells.EntityCurvedProjectile;
import alexthw.ars_elemental.common.entity.spells.EntityHomingProjectile;
import alexthw.ars_elemental.common.glyphs.EffectBubbleShield;
import alexthw.ars_elemental.common.glyphs.EffectCharm;
import alexthw.ars_elemental.common.glyphs.EffectConjureTerrain;
import alexthw.ars_elemental.common.glyphs.EffectDischarge;
import alexthw.ars_elemental.common.glyphs.EffectLifeLink;
import alexthw.ars_elemental.common.glyphs.EffectPhantom;
import alexthw.ars_elemental.common.glyphs.EffectSpores;
import alexthw.ars_elemental.common.glyphs.EffectWaterGrave;
import alexthw.ars_elemental.common.glyphs.MethodCurvedProjectile;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.common.glyphs.PropagatorArc;
import alexthw.ars_elemental.common.glyphs.PropagatorHoming;
import alexthw.ars_elemental.common.glyphs.filters.AerialFilter;
import alexthw.ars_elemental.common.glyphs.filters.AquaticFilter;
import alexthw.ars_elemental.common.glyphs.filters.FieryFilter;
import alexthw.ars_elemental.common.glyphs.filters.InsectFilter;
import alexthw.ars_elemental.common.glyphs.filters.SummonFilter;
import alexthw.ars_elemental.common.glyphs.filters.UndeadFilter;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.common.items.armor.ShockPerk;
import alexthw.ars_elemental.common.items.armor.SporePerk;
import alexthw.ars_elemental.common.items.armor.SummonPerk;
import alexthw.ars_elemental.common.rituals.AttractionRitual;
import alexthw.ars_elemental.common.rituals.DetectionRitual;
import alexthw.ars_elemental.common.rituals.RepulsionRitual;
import alexthw.ars_elemental.common.rituals.SquirrelRitual;
import alexthw.ars_elemental.common.rituals.TeslaRitual;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.RotatingSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFirework;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonUndead;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonVex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWindshear;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWither;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.APIRegistry;
import com.hollingsworth.arsnouveau.setup.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ArsNouveauRegistry {
    public static final List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();
    public static final SpellSchool NECROMANCY = new SpellSchool("necromancy");

    public static void init() {
        ArsNouveauRegistry.registerGlyphs();
        ArsNouveauRegistry.registerRituals();
        ArsNouveauRegistry.registerFamiliars(ArsNouveauAPI.getInstance());
        ArsNouveauRegistry.registerPerks();
        ArsNouveauRegistry.addDamageReductions();
    }

    private static void addDamageReductions() {
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_FIRE, Arrays.asList(DamageSource.f_19307_, DamageSource.f_19308_, DamageSource.f_19305_, DamageSource.f_19309_, DamageSource.f_19323_, new DamageSource("explosion"), new DamageSource("explosion.player"), new DamageSource("fireworks")));
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_WATER, Arrays.asList(DamageSource.f_19312_, DamageSource.f_146701_, DamageSource.f_19319_, DamageSource.f_19306_, new DamageSource("thorns")));
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_AIR, Arrays.asList(DamageSource.f_19315_, DamageSource.f_19316_, DamageSource.f_19310_, DamageSource.f_19306_, new DamageSource("sonic_boom")));
        IElementalArmor.damageResistances.put(SpellSchools.ELEMENTAL_EARTH, Arrays.asList(DamageSource.f_19314_, DamageSource.f_19313_, DamageSource.f_19325_, DamageSource.f_19314_, DamageSource.f_19310_, new DamageSource("poison")));
    }

    public static void registerGlyphs() {
        ArsNouveauRegistry.register((AbstractSpellPart)EffectWaterGrave.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectBubbleShield.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectConjureTerrain.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectCharm.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectPhantom.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectLifeLink.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectSpores.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)EffectDischarge.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)MethodHomingProjectile.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)MethodCurvedProjectile.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)PropagatorHoming.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)PropagatorArc.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AquaticFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AquaticFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)FieryFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)FieryFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AerialFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)AerialFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)InsectFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)InsectFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)UndeadFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)UndeadFilter.NOT_INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)SummonFilter.INSTANCE);
        ArsNouveauRegistry.register((AbstractSpellPart)SummonFilter.NOT_INSTANCE);
    }

    public static void registerRituals() {
        ArsNouveauRegistry.registerRitual(new SquirrelRitual());
        ArsNouveauRegistry.registerRitual(new TeslaRitual());
        ArsNouveauRegistry.registerRitual(new DetectionRitual());
        ArsNouveauRegistry.registerRitual(new RepulsionRitual());
        ArsNouveauRegistry.registerRitual(new AttractionRitual());
    }

    public static void registerRitual(AbstractRitual ritual) {
        ArsNouveauAPI.getInstance().registerRitual(ritual);
    }

    public static void postInit() {
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectHeal.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectSummonVex.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectWither.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectHex.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectLifeLink.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectCharm.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectSummonUndead.INSTANCE, NECROMANCY);
        ArsNouveauRegistry.addSchool((AbstractSpellPart)EffectCut.INSTANCE, SpellSchools.ELEMENTAL_AIR);
        EffectFirework.INSTANCE.compatibleAugments.add(AugmentDampen.INSTANCE);
        EffectLaunch.INSTANCE.compatibleAugments.add(AugmentExtendTime.INSTANCE);
        EffectLaunch.INSTANCE.compatibleAugments.add(AugmentDurationDown.INSTANCE);
        EffectGravity.INSTANCE.compatibleAugments.add(AugmentSensitive.INSTANCE);
        EffectWindshear.INSTANCE.compatibleAugments.add(AugmentFortune.INSTANCE);
        ArsNouveauRegistry.addLights();
        ArsNouveauRegistry.addPerkSlots();
        ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().add((RecipeType)ModRegistry.NETHERITE_UP.get());
        ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().add((RecipeType)ModRegistry.ELEMENTAL_ARMOR_UP.get());
        FirenandoFamiliar.projectileGlyphs.addAll(List.of(MethodCurvedProjectile.INSTANCE, MethodHomingProjectile.INSTANCE, MethodProjectile.INSTANCE, PropagatorHoming.INSTANCE, PropagatorArc.INSTANCE));
    }

    public static void addSchool(AbstractSpellPart part, SpellSchool school) {
        part.spellSchools.add(school);
        school.addSpellPart(part);
    }

    public static void register(AbstractSpellPart spellPart) {
        ArsNouveauAPI.getInstance().registerSpell(spellPart);
        registeredSpells.add(spellPart);
    }

    public static void registerFamiliars(ArsNouveauAPI api) {
        api.registerFamiliar((AbstractFamiliarHolder)new MermaidHolder());
        api.registerFamiliar((AbstractFamiliarHolder)new FirenandoHolder());
    }

    public static void registerPerks() {
        APIRegistry.registerPerk((IPerk)SporePerk.INSTANCE);
        APIRegistry.registerPerk((IPerk)ShockPerk.INSTANCE);
        APIRegistry.registerPerk((IPerk)SummonPerk.INSTANCE);
    }

    private static void addPerkSlots() {
        ArsNouveauAPI api = ArsNouveauAPI.getInstance();
        ArmorSet[] medium_armors = new ArmorSet[]{ModItems.AIR_ARMOR, ModItems.FIRE_ARMOR, ModItems.EARTH_ARMOR, ModItems.WATER_ARMOR};
        List<PerkSlot> perkSlots = Arrays.asList(PerkSlot.ONE, PerkSlot.TWO, PerkSlot.THREE);
        for (ArmorSet set : medium_armors) {
            api.registerPerkProvider((ItemLike)set.getHat(), stack -> new ArmorPerkHolder(stack, List.of(perkSlots, perkSlots, perkSlots, perkSlots)));
            api.registerPerkProvider((ItemLike)set.getChest(), stack -> new ArmorPerkHolder(stack, List.of(perkSlots, perkSlots, perkSlots, perkSlots)));
            api.registerPerkProvider((ItemLike)set.getLegs(), stack -> new ArmorPerkHolder(stack, List.of(perkSlots, perkSlots, perkSlots, perkSlots)));
            api.registerPerkProvider((ItemLike)set.getBoots(), stack -> new ArmorPerkHolder(stack, List.of(perkSlots, perkSlots, perkSlots, perkSlots)));
        }
    }

    public static void addLights() {
        Config.ITEM_LIGHTMAP.put(ModItems.FLASHING_POD.getId(), 14);
        LightManager.register((EntityType)((EntityType)ModEntities.HOMING_PROJECTILE.get()), p -> 15);
        LightManager.register((EntityType)((EntityType)ModEntities.CURVED_PROJECTILE.get()), p -> 15);
        LightManager.register((EntityType)((EntityType)ModEntities.FIRENANDO_ENTITY.get()), p -> {
            if (p.f_19853_.m_45517_(LightLayer.BLOCK, p.m_20183_()) < 6) {
                return 10;
            }
            return 0;
        });
        LightManager.register((EntityType)((EntityType)ModEntities.FIRENANDO_FAMILIAR.get()), p -> {
            if (p.f_19853_.m_45517_(LightLayer.BLOCK, p.m_20183_()) < 6) {
                return 10;
            }
            return 0;
        });
    }

    static {
        RotatingSpellTurret.ROT_TURRET_BEHAVIOR_MAP.put(MethodHomingProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityHomingProjectile spell = new EntityHomingProjectile((Level)world, resolver);
                spell.m_5602_((Entity)fakePlayer);
                spell.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                spell.setIgnored(MethodHomingProjectile.basicIgnores((LivingEntity)fakePlayer, resolver.spell.getAugments(0, null).contains(AugmentSensitive.INSTANCE), resolver.spell));
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().m_82541_();
                    spell.m_6686_(vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0.25f, 0.0f);
                }
                world.m_7967_((Entity)spell);
            }
        });
        RotatingSpellTurret.ROT_TURRET_BEHAVIOR_MAP.put(MethodCurvedProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityCurvedProjectile spell = new EntityCurvedProjectile((Level)world, resolver);
                spell.m_5602_((Entity)fakePlayer);
                spell.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof RotatingTurretTile) {
                    RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                    Vec3 vec3d = rotatingTurretTile.getShootAngle().m_82541_();
                    spell.m_6686_(vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 0.6f, 0.0f);
                }
                world.m_7967_((Entity)spell);
            }
        });
        BasicSpellTurret.TURRET_BEHAVIOR_MAP.put(MethodHomingProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityHomingProjectile spell = new EntityHomingProjectile((Level)world, resolver);
                spell.m_5602_((Entity)fakePlayer);
                spell.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                spell.setIgnored(MethodHomingProjectile.basicIgnores((LivingEntity)fakePlayer, resolver.spell.getAugments(0, null).contains(AugmentSensitive.INSTANCE), resolver.spell));
                spell.m_6686_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_(), 0.25f, 0.0f);
                world.m_7967_((Entity)spell);
            }
        });
        BasicSpellTurret.TURRET_BEHAVIOR_MAP.put(MethodCurvedProjectile.INSTANCE, new ITurretBehavior(){

            public void onCast(SpellResolver resolver, ServerLevel world, BlockPos pos, Player fakePlayer, Position position, Direction direction) {
                EntityCurvedProjectile spell = new EntityCurvedProjectile((Level)world, resolver);
                spell.m_5602_((Entity)fakePlayer);
                spell.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                spell.m_6686_(direction.m_122429_(), (float)direction.m_122430_() + 0.25f, direction.m_122431_(), 0.6f, 0.0f);
                world.m_7967_((Entity)spell);
            }
        });
    }
}

