/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.builder;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.allthemods.alltheores.datagen.RecipeException;
import net.allthemods.alltheores.infos.ItemTagRegistry;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class ShapedBlockBuilder {
    private final String criteriaName;
    private final InventoryChangeTrigger.TriggerInstance criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> ingot;
    private final TagKey<Item> hammer = ItemTagRegistry.ORE_HAMMERS;
    private final TagKey<Item> nugget = ItemTagRegistry.IRON_NUGGET;

    public ShapedBlockBuilder(TagKey<Item> ingot) {
        this.ingot = ingot;
        this.criteriaName = String.format("has_%s_ingot", ingot);
        ItemPredicate predicate = ItemPredicate.Builder.m_45068_().m_204145_(ingot).m_45077_();
        this.criterion = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedBlockBuilder builder(TagKey<Item> ingot) {
        return new ShapedBlockBuilder(ingot);
    }

    public ShapedBlockBuilder setBlock(RegistryObject<Item> object) {
        this.pieces.put(Slot.BLOCK, (Item)object.get());
        return this;
    }

    public ShapedBlockBuilder setGear(RegistryObject<Item> object) {
        this.pieces.put(Slot.GEAR, (Item)object.get());
        return this;
    }

    public ShapedBlockBuilder setPlate(RegistryObject<Item> object) {
        this.pieces.put(Slot.PLATE, (Item)object.get());
        return this;
    }

    public ShapedBlockBuilder setRod(RegistryObject<Item> object) {
        this.pieces.put(Slot.ROD, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.m_176498_(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.BLOCK)).map(this::block).map(this::addCriterionIngot).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.GEAR)).map(this::gear).map(this::addCriterionIngot).map(this::addCriterionNugget).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.ROD)).map(this::rod).map(this::addCriterionIngot).map(this::addCriterionHammer).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.PLATE)).map(this::plate).map(this::addCriterionIngot).map(this::addCriterionHammer).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)provider).m_126145_("alltheores");
    }

    private ShapedRecipeBuilder addCriterionIngot(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('a'), this.ingot).m_126132_(this.criteriaName, (CriterionTriggerInstance)this.criterion);
    }

    private ShapedRecipeBuilder addCriterionHammer(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('h'), this.hammer);
    }

    private ShapedRecipeBuilder addCriterionNugget(ShapedRecipeBuilder builder) {
        return builder.m_206416_(Character.valueOf('i'), this.nugget);
    }

    private ShapedRecipeBuilder block(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("aaa").m_126130_("aaa");
    }

    private ShapedRecipeBuilder ingot(ItemLike provider) {
        return this.shaped(provider).m_126130_("aaa").m_126130_("aaa").m_126130_("aaa");
    }

    private ShapedRecipeBuilder gear(ItemLike provider) {
        return this.shaped(provider).m_126130_(" a ").m_126130_("aia").m_126130_(" a ");
    }

    private ShapedRecipeBuilder rod(ItemLike provider) {
        return this.shaped(provider).m_126130_("  a").m_126130_("ha ").m_126130_("   ");
    }

    private ShapedRecipeBuilder plate(ItemLike provider) {
        return this.shaped(provider).m_126130_("ha ").m_126130_("a  ").m_126130_("   ");
    }

    public static enum Slot {
        BLOCK,
        GEAR,
        ROD,
        PLATE;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

