/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.container;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.smashingmods.alchemylib.api.blockentity.container.WrappedVertexConsumer;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FakeItemRenderer {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final ItemRenderer ITEM_RENDERER = MINECRAFT.m_91291_();
    private static final TextureManager TEXTURE_MANAGER = MINECRAFT.m_91097_();

    public static void renderFakeItem(ItemStack pItemStack, int pX, int pY) {
        FakeItemRenderer.renderFakeItem(pItemStack, pX, pY, 1.0f);
    }

    public static void renderFakeItem(ItemStack pItemStack, int pX, int pY, float pAlpha) {
        if (!pItemStack.m_41619_()) {
            BakedModel model = FakeItemRenderer.getBakedModel(pItemStack);
            TEXTURE_MANAGER.m_118506_(InventoryMenu.f_39692_).m_117960_(true, false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69478_();
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_85837_((double)pX + 8.0, (double)pY + 8.0, 0.0);
            modelViewStack.m_85841_(16.0f, -16.0f, 16.0f);
            RenderSystem.m_157182_();
            if (!model.m_7547_()) {
                Lighting.m_84930_();
            }
            MultiBufferSource.BufferSource bufferSource = MINECRAFT.m_91269_().m_110104_();
            ITEM_RENDERER.m_115143_(pItemStack, ItemTransforms.TransformType.GUI, false, new PoseStack(), FakeItemRenderer.getWrappedBuffer((MultiBufferSource)bufferSource, pAlpha), 0xF000F0, OverlayTexture.f_118083_, model);
            bufferSource.m_109911_();
            RenderSystem.m_69482_();
            if (!model.m_7547_()) {
                Lighting.m_84931_();
            }
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    private static MultiBufferSource getWrappedBuffer(MultiBufferSource pBufferSource, float pAlpha) {
        return pRenderType -> new WrappedVertexConsumer(pBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_)), 1.0f, 1.0f, 1.0f, pAlpha);
    }

    private static BakedModel getBakedModel(ItemStack pItemStack) {
        ModelResourceLocation chemicalModel = FakeItemRenderer.getChemicalModel(pItemStack);
        return chemicalModel != null ? ITEM_RENDERER.m_115103_().m_109393_().m_119422_(chemicalModel) : ITEM_RENDERER.m_174264_(pItemStack, null, (LivingEntity)FakeItemRenderer.MINECRAFT.f_91074_, 0);
    }

    @Nullable
    private static ModelResourceLocation getChemicalModel(ItemStack pItemStack) {
        ModelResourceLocation modelResourceLocation = null;
        Item item = pItemStack.m_41720_();
        if (item instanceof ElementItem) {
            ElementItem elementItem = (ElementItem)item;
            switch (elementItem.getMatterState()) {
                case LIQUID: {
                    modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "element_liquid_model"), "inventory");
                    break;
                }
                case GAS: {
                    modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "element_gas_model"), "inventory");
                    break;
                }
                default: {
                    modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "element_solid_model"), "inventory");
                    break;
                }
            }
        } else {
            item = pItemStack.m_41720_();
            if (item instanceof ChemicalItem) {
                ChemicalItem chemicalItem = (ChemicalItem)item;
                switch (chemicalItem.getItemType()) {
                    case DUST: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_dust_model"), "inventory");
                        break;
                    }
                    case NUGGET: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_nugget_model"), "inventory");
                        break;
                    }
                    case INGOT: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_ingot_model"), "inventory");
                        break;
                    }
                    case PLATE: {
                        modelResourceLocation = new ModelResourceLocation(new ResourceLocation("chemlib", "chemical_plate_model"), "inventory");
                    }
                }
            }
        }
        return modelResourceLocation;
    }
}

