/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network;

import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractProcessingBlockEntity;
import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetRecipePacket
implements AlchemyPacket {
    private final BlockPos blockPos;
    private final ResourceLocation recipeId;
    private final String group;

    public SetRecipePacket(BlockPos pBlockPos, ResourceLocation pRecipeId, String pGroup) {
        this.blockPos = pBlockPos;
        this.recipeId = pRecipeId;
        this.group = pGroup;
    }

    public SetRecipePacket(FriendlyByteBuf pBuffer) {
        this.blockPos = pBuffer.m_130135_();
        this.recipeId = pBuffer.m_130281_();
        this.group = pBuffer.m_130277_();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130064_(this.blockPos);
        pBuffer.m_130085_(this.recipeId);
        pBuffer.m_130070_(this.group);
    }

    public void handle(NetworkEvent.Context pContext) {
        ServerPlayer player = pContext.getSender();
        Objects.requireNonNull(player);
        Objects.requireNonNull(player.m_9236_());
        Level level = player.m_9236_();
        BlockEntity blockEntity = player.m_9236_().m_7702_(this.blockPos);
        RecipeRegistry.getRecipeByGroupAndId(this.group, this.recipeId, level).ifPresent(recipe -> {
            if (blockEntity instanceof AbstractProcessingBlockEntity) {
                AbstractProcessingBlockEntity processingBlockEntity = (AbstractProcessingBlockEntity)blockEntity;
                processingBlockEntity.setProgress(0);
                processingBlockEntity.setRecipe(recipe);
                processingBlockEntity.m_6596_();
            }
        });
    }
}

