/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.combiner;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.combiner.CombinerMenu;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractSearchableBlockEntity;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinerBlockEntity
extends AbstractSearchableBlockEntity {
    private CombinerRecipe currentRecipe;
    private ResourceLocation recipeId;

    public CombinerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super("alchemistry", (BlockEntityType)BlockEntityRegistry.COMBINER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setEnergyPerTick((Integer)Config.Common.combinerEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.combinerTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getCombinerRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    public void updateRecipe() {
        if (!(this.f_58857_ == null || this.f_58857_.m_5776_() || this.getInputHandler().isEmpty() || this.isRecipeLocked())) {
            RecipeRegistry.getCombinerRecipe(recipe -> recipe.matchInputs((List<ItemStack>)this.getInputHandler().getStacks()), this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !((Object)((Object)this.currentRecipe)).equals(recipe)) {
                    this.setProgress(0);
                    this.setRecipe(recipe.copy());
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        if (this.currentRecipe != null) {
            CombinerRecipe tempRecipe = this.currentRecipe.copy();
            ItemStack output = this.getOutputHandler().getStackInSlot(0).m_41777_();
            return this.getEnergyHandler().getEnergyStored() >= this.getEnergyPerTick() && tempRecipe.getOutput().m_41613_() + output.m_41613_() <= tempRecipe.getOutput().m_41741_() && (ItemStack.m_150942_((ItemStack)output, (ItemStack)tempRecipe.getOutput()) || output.m_41619_()) && tempRecipe.matchInputs((List<ItemStack>)this.getInputHandler().getStacks());
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            CombinerRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getOutputHandler().setOrIncrement(0, tempRecipe.getOutput());
            block0: for (int i = 0; i < tempRecipe.getInput().size(); ++i) {
                for (int j = 0; j < this.getInputHandler().getStacks().size(); ++j) {
                    if (!((IngredientStack)tempRecipe.getInput().get(i)).matches(this.getInputHandler().getStackInSlot(j))) continue;
                    this.getInputHandler().decrementSlot(j, ((IngredientStack)tempRecipe.getInput().get(i)).getCount());
                    continue block0;
                }
            }
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof CombinerRecipe) {
            CombinerRecipe combinerRecipe;
            this.currentRecipe = combinerRecipe = (CombinerRecipe)pRecipe;
        }
    }

    public CombinerRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<CombinerRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<CombinerRecipe>(RecipeRegistry.getCombinerRecipes(this.f_58857_));
        }
        return new LinkedList<CombinerRecipe>();
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.combinerEnergyCapacity.get()){

            protected void onEnergyChanged() {
                CombinerBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(4){

            protected void onContentsChanged(int slot) {
                CombinerBlockEntity.this.setCanProcess(CombinerBlockEntity.this.canProcessRecipe());
                CombinerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int pSlot, @NotNull ItemStack pItemStack) {
                if (CombinerBlockEntity.this.currentRecipe != null && CombinerBlockEntity.this.isRecipeLocked()) {
                    boolean notContained = this.getStacks().stream().noneMatch(itemStack -> ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)pItemStack));
                    boolean inputRequired = CombinerBlockEntity.this.currentRecipe.getInput().stream().map(IngredientStack::getIngredient).anyMatch(ingredient -> ingredient.test(pItemStack));
                    boolean itemMatchesSlot = ItemStack.m_150942_((ItemStack)pItemStack, (ItemStack)this.getStackInSlot(pSlot));
                    return itemMatchesSlot || notContained && inputRequired;
                }
                return super.isItemValid(pSlot, pItemStack);
            }
        };
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }
        };
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getCombinerRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new CombinerMenu(pContainerId, pInventory, (BlockEntity)this);
    }
}

