/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.sound;

import earth.terrarium.ad_astra.common.registry.ModSoundEvents;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlanetWeatherSoundPlayer
implements AmbientSoundHandler {
    private final LocalPlayer player;
    private final SoundManager soundManager;
    private final List<MusicLoop> soundLoops = new LinkedList<MusicLoop>();

    public PlanetWeatherSoundPlayer(LocalPlayer player, SoundManager soundManager) {
        this.player = player;
        this.soundManager = soundManager;
    }

    public void m_7551_() {
        this.soundLoops.removeIf(AbstractTickableSoundInstance::m_7801_);
        if (this.soundLoops.isEmpty() && ModUtils.isPlanet(this.player.f_19853_) && ModUtils.planetHasAtmosphere(this.player.f_19853_)) {
            MusicLoop loop = new MusicLoop(this.player, (SoundEvent)ModSoundEvents.WINDY.get());
            this.soundLoops.add(loop);
            this.soundManager.m_120367_((SoundInstance)loop);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MusicLoop
    extends AbstractTickableSoundInstance {
        private final LocalPlayer player;

        public MusicLoop(LocalPlayer player, SoundEvent soundEvent) {
            super(soundEvent, SoundSource.WEATHER, SoundInstance.m_235150_());
            this.player = player;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 1.0f;
            this.f_119582_ = true;
        }

        public void m_7788_() {
            if (this.player.m_213877_()) {
                this.m_119609_();
                return;
            }
            ClientLevel level = (ClientLevel)this.player.m_9236_();
            Minecraft minecraft = Minecraft.m_91087_();
            double height = 80.0;
            double max = 0.2;
            if (level.m_46471_()) {
                height -= 10.0;
                max += 0.1;
            }
            if (level.m_46470_()) {
                height -= 50.0;
                max += 0.2;
            }
            float volume = (float)Mth.m_14008_((double)((this.player.m_20186_() - 80.0) / height), (double)0.0, (double)max);
            if (minecraft.f_91080_ != null && minecraft.f_91080_.m_7043_()) {
                volume = 0.0f;
                return;
            }
            if (!ModUtils.isPlanet((Level)level)) {
                volume = 0.0f;
                return;
            }
            this.f_119573_ = Mth.m_14036_((float)volume, (float)0.0f, (float)1.0f);
        }
    }
}

