/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.IColorable;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.world.content.WorldContent;

public class LampSideBlock
extends SidePartBlock
implements IColorable {
    private final int _color;

    public LampSideBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this._color = ColorUtils.getColorFromDye((DyeColor)color);
        this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new LampSideBlock(color, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_154677_).m_60953_(state -> 15).m_60910_().m_60955_().m_60966_());
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), dyeColor == DyeColor.WHITE ? new Item.Properties().m_41491_(WorldContent.Tab) : new Item.Properties());
    }

    private EnumMap<DyeColor, BlockContent> getCurrentMap(int light, BlockState state) {
        return WorldContent.LampPole;
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.m_43723_()).m_21206_();
        BlockState state = super.m_5573_(context);
        int light = state.getLightEmission((BlockGetter)context.m_43725_(), context.m_8083_());
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        if (color != null) {
            FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
            state = (BlockState)((BlockState)this.getCurrentMap(light, state).get(color).block().m_49966_().m_61124_((Property)DIRECTION, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return state;
    }

    public VoxelShape getDownShapeForBaking() {
        return LampSideBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.25, (double)12.0);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        EnumMap<DyeColor, BlockContent> currentMap;
        BlockContent blockType;
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)interactionHand);
        if (interactionResult != InteractionResult.PASS) {
            return interactionResult;
        }
        ItemStack stack = player.m_21120_(interactionHand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (dyeColor != null && (blockType = (currentMap = this.getCurrentMap(state.getLightEmission((BlockGetter)level, pos), state)).get(dyeColor)).block() != this) {
            level.m_7731_(pos, (BlockState)((BlockState)blockType.block().m_49966_().m_61124_((Property)DIRECTION, (Comparable)((Direction)state.m_61143_((Property)DIRECTION)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_))), 11);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this._color;
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index != 0) {
            return -1;
        }
        return this._color;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83110_((VoxelShape)super.m_5940_(state, level, pos, context), (VoxelShape)LampSideBlock.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0));
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.AIR;
    }
}

