/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.world.content.WorldContent;

public class AureyBlock
extends ColoredBlock {
    private final DyeColor _dyeColor;

    public AureyBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(ColorUtils.getColorFromDye((DyeColor)color), properties);
        this._dyeColor = color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumMap<DyeColor, BlockContent> getCurrentMap(int light, BlockState state) {
        EnumMap<DyeColor, BlockContent> currentMap;
        EnumMap<DyeColor, BlockContent> enumMap = currentMap = light > 0 ? WorldContent.AureyBlockMatteGlowing : WorldContent.AureyBlockMatte;
        if (light > 0) {
            if (WorldContent.AureyBlockFxGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                return WorldContent.AureyBlockFxGlowing;
            }
        }
        if (!WorldContent.AureyBlockFx.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) return currentMap;
        return WorldContent.AureyBlockFx;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        EnumMap<DyeColor, BlockContent> currentMap = state.getLightEmission(level, pos) > 0 ? WorldContent.AureyBlockMatteGlowing : WorldContent.AureyBlockMatte;
        return new ItemStack((ItemLike)currentMap.get(DyeColor.PINK).block(), 1);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        EnumMap<DyeColor, BlockContent> currentMap;
        BlockContent blockType;
        DyeColor dyeColor;
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)interactionHand);
        if (interactionResult != InteractionResult.PASS) {
            return interactionResult;
        }
        ItemStack stack = player.m_21120_(interactionHand);
        if (stack.m_41619_() && interactionHand == InteractionHand.MAIN_HAND) {
            boolean wasLight = false;
            EnumMap<DyeColor, BlockContent> map = WorldContent.AureyBlockMatte;
            if (WorldContent.AureyBlockMatte.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                map = WorldContent.AureyBlockFx;
            } else if (WorldContent.AureyBlockMatteGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                wasLight = true;
                map = player.m_6144_() ? WorldContent.AureyBlockMatte : WorldContent.AureyBlockFxGlowing;
            } else if (WorldContent.AureyBlockFxGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                wasLight = true;
                EnumMap<DyeColor, BlockContent> enumMap = map = player.m_6144_() ? WorldContent.AureyBlockFx : WorldContent.AureyBlockMatteGlowing;
            }
            if (wasLight && player.m_6144_()) {
                if (!level.m_5776_() && !player.m_7500_()) {
                    float f = 0.7f;
                    double d0 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
                    double d1 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
                    double d2 = (double)(level.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
                    ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, new ItemStack((ItemLike)Items.f_151056_));
                    itementity.m_32060_();
                    level.m_7967_((Entity)itementity);
                }
                level.m_46597_(pos, (BlockState)map.get(this._dyeColor).block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!player.m_6144_()) {
                level.m_46597_(pos, (BlockState)map.get(this._dyeColor).block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (stack.m_41720_() == Items.f_151056_) {
            if (WorldContent.AureyBlockMatteGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                if (WorldContent.AureyBlockFxGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                    EnumMap<DyeColor, BlockContent> currentMap2;
                    EnumMap<DyeColor, BlockContent> enumMap = currentMap2 = WorldContent.AureyBlockFx.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0)) ? WorldContent.AureyBlockFxGlowing : WorldContent.AureyBlockMatteGlowing;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
                    }
                    stack.m_41774_(player.m_7500_() ? 0 : 1);
                    level.m_46597_(pos, (BlockState)currentMap2.get(this._dyeColor).block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        if ((dyeColor = DyeColor.getColor((ItemStack)stack)) != null && (blockType = (currentMap = this.getCurrentMap(state.getLightEmission((BlockGetter)level, pos), state)).get(dyeColor)).block() != this) {
            level.m_7731_(pos, (BlockState)blockType.block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))), 11);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.m_43723_()).m_21206_();
        BlockState state = this.m_49966_();
        int light = state.getLightEmission((BlockGetter)context.m_43725_(), context.m_8083_());
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        if (color != null) {
            state = this.getCurrentMap(light, state).get(color).block().m_49966_();
        }
        return (BlockState)state.m_61124_((Property)Spawnable, (Comparable)Boolean.valueOf(false));
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new AureyBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)WorldContent.AluminumStorage.block()));
    }

    public static Supplier<Block> blockSupplierGlow(DyeColor color) {
        return () -> new AureyBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)WorldContent.AluminumStorage.block()).m_60953_(state -> 15));
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), dyeColor == DyeColor.PINK ? new Item.Properties().m_41491_(WorldContent.Tab) : new Item.Properties());
    }

    public static Supplier<Item> itemSupplierHidden(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }
}

