/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.communication.FoodListMessage;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class CapabilityHandler {
    private static final ResourceLocation FOOD = SOLCarrot.resourceLocation("food");

    @SubscribeEvent
    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        event.addCapability(FOOD, (ICapabilityProvider)new FoodList());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLCarrotConfig.shouldResetOnDeath()) {
            return;
        }
        Player originalPlayer = event.getOriginal();
        originalPlayer.revive();
        FoodList original = FoodList.get(originalPlayer);
        FoodList newInstance = FoodList.get(event.getEntity());
        newInstance.deserializeNBT(original.serializeNBT());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    public static void syncFoodList(Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        ServerPlayer target = (ServerPlayer)player;
        SOLCarrot.channel.sendTo((Object)new FoodListMessage(FoodList.get(player)), target.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        MaxHealthHandler.updateFoodHPModifier(player);
    }

    @Mod.EventBusSubscriber(modid="solcarrot", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static final class Setup {
        private Setup() {
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.register(FoodCapability.class);
        }
    }
}

